/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.concurrent;

import java.util.Calendar;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.Assert;
import org.jrebirth.af.core.application.ApplicationTest;
import org.jrebirth.af.core.concurrent.AbstractJrbRunnable;
import org.jrebirth.af.core.concurrent.JRebirth;
import org.jrebirth.af.core.concurrent.JRebirthRunnable;
import org.jrebirth.af.core.concurrent.RunnablePriority;
import org.jrebirth.af.core.concurrent.ThreadApplication;
import org.jrebirth.af.core.exception.JRebirthThreadException;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore(value="JavaFX can't be run in headless mode yet")
public class ThreadTest
extends ApplicationTest<ThreadApplication> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadTest.class);

    public ThreadTest() {
        super(ThreadApplication.class);
    }

    public void testJAT() {
        final AtomicBoolean ok = new AtomicBoolean(false);
        JRebirth.runIntoJAT((JRebirthRunnable)new AbstractJrbRunnable("Jat test"){

            protected void runInto() throws JRebirthThreadException {
                LOGGER.info("Running into " + Thread.currentThread().getName());
                ok.set(JRebirth.isJAT());
            }
        });
        this.checkBoolean(ok);
    }

    public void testJIT() {
        final AtomicBoolean ok = new AtomicBoolean(false);
        JRebirth.runIntoJIT((JRebirthRunnable)new AbstractJrbRunnable("JIT test"){

            protected void runInto() throws JRebirthThreadException {
                LOGGER.info("Running into " + Thread.currentThread().getName());
                ok.set(JRebirth.isJIT());
            }
        });
        this.checkBoolean(ok);
    }

    public void testJTP() {
        final AtomicBoolean ok = new AtomicBoolean(false);
        JRebirth.runIntoJTP((JRebirthRunnable)new AbstractJrbRunnable("JTP test"){

            protected void runInto() throws JRebirthThreadException {
                LOGGER.info("Running into " + Thread.currentThread().getName());
                ok.set(JRebirth.isJTPSlot());
            }
        });
        this.checkBoolean(ok);
    }

    @Test
    public void testPHTP() {
        try {
            JRebirth.runIntoJTP((JRebirthRunnable)new LongTask("1", RunnablePriority.Normal));
            JRebirth.runIntoJTP((JRebirthRunnable)new LongTask("2", RunnablePriority.Normal));
            JRebirth.runIntoJTP((JRebirthRunnable)new LongTask("3", RunnablePriority.Normal));
            JRebirth.runIntoJTP((JRebirthRunnable)new LongTask("4", RunnablePriority.Normal));
            JRebirth.runIntoJTP((JRebirthRunnable)new LongTask("5", RunnablePriority.Normal));
            JRebirth.runIntoJTP((JRebirthRunnable)new LongTask("6", RunnablePriority.Normal));
            JRebirth.runIntoJTP((JRebirthRunnable)new LongTask("7", RunnablePriority.Normal));
            JRebirth.runIntoJTP((JRebirthRunnable)new LongTask("8", RunnablePriority.Normal));
            JRebirth.runIntoJTP((JRebirthRunnable)new LongTask("9", RunnablePriority.Lowest));
            JRebirth.runIntoJTP((JRebirthRunnable)new LongTask("10", RunnablePriority.Normal));
            JRebirth.runIntoJTP((JRebirthRunnable)new LongTask("11", RunnablePriority.Low));
            JRebirth.runIntoJTP((JRebirthRunnable)new LongTask("12", RunnablePriority.Normal));
            JRebirth.runIntoJTP((JRebirthRunnable)new LongTask("13", RunnablePriority.High));
            JRebirth.runIntoJTP((JRebirthRunnable)new LongTask("14", RunnablePriority.Highest));
            JRebirth.runIntoJTP((JRebirthRunnable)new LongTask("15", RunnablePriority.Lowest));
            JRebirth.runIntoJTP((JRebirthRunnable)new LongTask("16", RunnablePriority.Low));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkBoolean(AtomicBoolean ok) {
        for (int i = 0; !ok.get() && i < 10; ++i) {
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Assert.assertEquals((boolean)true, (boolean)ok.get());
    }

    private class LongTask
    implements JRebirthRunnable {
        String name;
        RunnablePriority priority;
        long time;

        public LongTask(String string, RunnablePriority normal) {
            this.name = string;
            this.priority = normal;
            this.time = Calendar.getInstance().getTimeInMillis();
            LOGGER.info("Creating " + this.name + "(" + this.priority.name() + ") into " + Thread.currentThread().getName());
        }

        public void run() {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            LOGGER.info("Running " + this.name + "(" + this.priority.name() + ") into " + Thread.currentThread().getName());
        }

        public RunnablePriority getPriority() {
            return this.priority;
        }

        public long getCreationTime() {
            return this.time;
        }
    }
}

