/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.facade;

import org.jrebirth.af.core.application.JRebirthApplication;
import org.jrebirth.af.core.application.TestApplication;
import org.jrebirth.af.core.command.basic.SwitchFullScreenCommand;
import org.jrebirth.af.core.facade.CommandFacade;
import org.jrebirth.af.core.facade.FacadeReady;
import org.jrebirth.af.core.facade.GlobalFacadeBase;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class FacadeTest {
    private static GlobalFacadeBase globalFacade;
    private CommandFacade commandFacade;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        globalFacade = new GlobalFacadeBase((JRebirthApplication)new TestApplication());
    }

    @Before
    public void setUp() throws Exception {
        this.commandFacade = globalFacade.getCommandFacade();
    }

    @Test
    public void registerCommandWithKey() {
        long key = System.currentTimeMillis();
        SwitchFullScreenCommand command = new SwitchFullScreenCommand();
        this.commandFacade.register((FacadeReady)command, new Object[]{key});
        Assert.assertTrue((boolean)this.commandFacade.exists(SwitchFullScreenCommand.class, new Object[]{key}));
    }

    @Test
    public void registerCommandWithOutKey() {
        SwitchFullScreenCommand command = new SwitchFullScreenCommand();
        this.commandFacade.register((FacadeReady)command, new Object[0]);
        Assert.assertTrue((boolean)this.commandFacade.exists(SwitchFullScreenCommand.class, new Object[0]));
    }

    @Test
    public void retrieveCommand() {
        long key = System.currentTimeMillis();
        SwitchFullScreenCommand command = (SwitchFullScreenCommand)this.commandFacade.retrieve(SwitchFullScreenCommand.class, new Object[]{key});
        Assert.assertNotNull((Object)command);
    }

    @Test
    public void unregisterCommandWithOutKey() {
        SwitchFullScreenCommand command = (SwitchFullScreenCommand)this.commandFacade.retrieve(SwitchFullScreenCommand.class, new Object[0]);
        this.commandFacade.unregister((FacadeReady)command, new Object[0]);
        Assert.assertNotNull((Object)this.commandFacade.exists(SwitchFullScreenCommand.class, new Object[0]));
    }

    @Test
    public void unregisterCommandWithKey() {
        long key = System.currentTimeMillis();
        SwitchFullScreenCommand command = (SwitchFullScreenCommand)this.commandFacade.retrieve(SwitchFullScreenCommand.class, new Object[]{key});
        this.commandFacade.unregister((FacadeReady)command, new Object[]{key});
        junit.framework.Assert.assertNotNull((Object)this.commandFacade.exists(SwitchFullScreenCommand.class, new Object[]{key}));
    }

    @After
    public void tearDown() throws Exception {
        this.commandFacade = null;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        globalFacade.stop();
        globalFacade = null;
    }
}

