/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.resource.color;

import javafx.scene.paint.Color;
import org.jrebirth.af.core.resource.ResourceBuilders;
import org.jrebirth.af.core.resource.ResourceItem;
import org.jrebirth.af.core.resource.color.ColorItem;
import org.jrebirth.af.core.resource.color.GrayColor;
import org.jrebirth.af.core.resource.color.HSBColor;
import org.jrebirth.af.core.resource.color.RGB01Color;
import org.jrebirth.af.core.resource.color.RGB255Color;
import org.jrebirth.af.core.resource.color.TestColors;
import org.jrebirth.af.core.resource.color.WebColor;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ColorTest {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void grayColor() {
        this.checkGrayColor(TestColors.TEST_COLOR_GRAY_1);
        this.checkGrayColor(TestColors.TEST_COLOR_GRAY_2);
        this.checkGrayColor(TestColors.TEST_COLOR_GRAY_3);
    }

    private void checkGrayColor(ColorItem colorItem) {
        Color color = (Color)colorItem.get();
        GrayColor wc = (GrayColor)ResourceBuilders.COLOR_BUILDER.getParam((ResourceItem)colorItem);
        Assert.assertEquals((double)color.getOpacity(), (double)wc.opacity(), (double)0.1);
    }

    @Test
    public void hsbColor() {
        this.checkHsbColor(TestColors.TEST_COLOR_HSB_1);
        this.checkHsbColor(TestColors.TEST_COLOR_HSB_2);
        this.checkHsbColor(TestColors.TEST_COLOR_HSB_3);
    }

    private void checkHsbColor(ColorItem colorItem) {
        Color color = (Color)colorItem.get();
        HSBColor wc = (HSBColor)ResourceBuilders.COLOR_BUILDER.getParam((ResourceItem)colorItem);
        Assert.assertEquals((double)color.getHue(), (double)wc.hue(), (double)1.0);
        Assert.assertEquals((double)color.getSaturation(), (double)wc.saturation(), (double)1.0E-6);
        Assert.assertEquals((double)color.getBrightness(), (double)wc.brightness(), (double)1.0E-6);
        Assert.assertEquals((double)color.getOpacity(), (double)wc.opacity(), (double)0.1);
    }

    @Test
    public void webColor() {
        this.checkWebColor(TestColors.TEST_COLOR_WEB_1);
        this.checkWebColor(TestColors.TEST_COLOR_WEB_2);
        this.checkWebColor(TestColors.TEST_COLOR_WEB_3);
    }

    private void checkWebColor(ColorItem colorItem) {
        Color color = (Color)colorItem.get();
        WebColor wc = (WebColor)ResourceBuilders.COLOR_BUILDER.getParam((ResourceItem)colorItem);
        Assert.assertEquals((double)color.getRed(), (double)this.convertHexToDouble(wc.hex().substring(0, 2)), (double)1.0E-6);
        Assert.assertEquals((double)color.getGreen(), (double)this.convertHexToDouble(wc.hex().substring(2, 4)), (double)1.0E-6);
        Assert.assertEquals((double)color.getBlue(), (double)this.convertHexToDouble(wc.hex().substring(4, 6)), (double)1.0E-6);
        Assert.assertEquals((double)color.getOpacity(), (double)wc.opacity(), (double)0.1);
    }

    @Test
    public void rgb01Color() {
        this.checkRgb01Color(TestColors.TEST_COLOR_RGB01_1);
        this.checkRgb01Color(TestColors.TEST_COLOR_RGB01_2);
        this.checkRgb01Color(TestColors.TEST_COLOR_RGB01_3);
    }

    private void checkRgb01Color(ColorItem colorItem) {
        Color color = (Color)colorItem.get();
        RGB01Color wc = (RGB01Color)ResourceBuilders.COLOR_BUILDER.getParam((ResourceItem)colorItem);
        Assert.assertEquals((double)color.getRed(), (double)wc.red(), (double)1.0E-6);
        Assert.assertEquals((double)color.getGreen(), (double)wc.green(), (double)1.0E-6);
        Assert.assertEquals((double)color.getBlue(), (double)wc.blue(), (double)1.0E-6);
        Assert.assertEquals((double)color.getOpacity(), (double)wc.opacity(), (double)0.1);
    }

    @Test
    public void rgb255Color() {
        this.checkRgb255Color(TestColors.TEST_COLOR_RGB255_1);
        this.checkRgb255Color(TestColors.TEST_COLOR_RGB255_2);
        this.checkRgb255Color(TestColors.TEST_COLOR_RGB255_3);
    }

    private void checkRgb255Color(ColorItem colorItem) {
        Color color = (Color)colorItem.get();
        RGB255Color wc = (RGB255Color)ResourceBuilders.COLOR_BUILDER.getParam((ResourceItem)colorItem);
        Assert.assertEquals((double)color.getRed(), (double)this.convert255To1(wc.red()), (double)1.0E-6);
        Assert.assertEquals((double)color.getGreen(), (double)this.convert255To1(wc.green()), (double)1.0E-6);
        Assert.assertEquals((double)color.getBlue(), (double)this.convert255To1(wc.blue()), (double)1.0E-6);
        Assert.assertEquals((double)color.getOpacity(), (double)wc.opacity(), (double)0.1);
    }

    private double convertHexToDouble(String hexaSingleColor) {
        int i = Integer.parseInt(hexaSingleColor, 16);
        return this.convert255To1(i);
    }

    private double convert255To1(int i) {
        return i == 0 ? (double)i : (double)i / 255.0;
    }

    @After
    public void tearDown() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }
}

