/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.resource.font;

import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import org.fest.assertions.Assertions;
import org.jrebirth.af.core.resource.ResourceBuilders;
import org.jrebirth.af.core.resource.ResourceItem;
import org.jrebirth.af.core.resource.font.AbstractBaseFont;
import org.jrebirth.af.core.resource.font.FamilyFont;
import org.jrebirth.af.core.resource.font.FontItem;
import org.jrebirth.af.core.resource.font.TestFonts;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class FontTest {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        System.out.println("2 << 1 = 2");
        System.out.println("2 << 2 = 4");
        System.out.println("2 << 3 = 8");
        System.out.println("2 << 4 = 16");
        System.out.println("2 << 5 = 32");
        System.out.println("2 << 6 = 64");
    }

    @Test
    public void realFont() {
        this.checkRealFont(TestFonts.TEST_REAL_FONT_1);
        this.checkRealFont(TestFonts.TEST_REAL_FONT_2);
    }

    private void checkRealFont(FontItem fontItem) {
        Font font = (Font)fontItem.get();
        AbstractBaseFont rf = (AbstractBaseFont)ResourceBuilders.FONT_BUILDER.getParam((ResourceItem)fontItem);
        Assert.assertNotNull((Object)font);
        Assert.assertEquals((Object)font.getName(), (Object)rf.name().name());
        Assert.assertEquals((double)font.getSize(), (double)rf.size(), (double)0.0);
    }

    @Test
    public void familyFont() {
        this.checkFamilyFont(TestFonts.TEST_FAMILY_FONT_1);
        this.checkFamilyFont(TestFonts.TEST_FAMILY_FONT_2);
        this.checkFamilyFont(TestFonts.TEST_FAMILY_FONT_3);
        this.checkFamilyFont(TestFonts.TEST_FAMILY_FONT_4);
    }

    private void checkFamilyFont(FontItem fontItem) {
        Font font = (Font)fontItem.get();
        FamilyFont ff = (FamilyFont)ResourceBuilders.FONT_BUILDER.getParam((ResourceItem)fontItem);
        junit.framework.Assert.assertNotNull((Object)font);
        String[] names = font.getName().split(" ");
        int i = 0;
        Assertions.assertThat((String)names[i++]).isEqualToIgnoringCase(ff.family());
        if (FontWeight.NORMAL != ff.weight()) {
            Assertions.assertThat((String)names[i++]).isEqualToIgnoringCase(ff.weight().name());
        }
        if (FontPosture.REGULAR != ff.posture()) {
            Assertions.assertThat((String)names[i++]).isEqualToIgnoringCase(ff.posture().name());
        }
        Assert.assertEquals((double)font.getSize(), (double)ff.size(), (double)0.0);
    }

    @After
    public void tearDown() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }
}

