/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.resource.image;

import java.util.Arrays;
import javafx.scene.image.Image;
import org.jrebirth.af.core.resource.AbstractBaseParams;
import org.jrebirth.af.core.resource.ResourceBuilders;
import org.jrebirth.af.core.resource.ResourceItem;
import org.jrebirth.af.core.resource.image.ImageItem;
import org.jrebirth.af.core.resource.image.RelImage;
import org.jrebirth.af.core.resource.image.TestImages;
import org.jrebirth.af.core.resource.provided.JRebirthParameters;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ImageTest {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        JRebirthParameters.IMAGE_FOLDER.define(Arrays.asList("images", "imagesBis"));
    }

    @Test
    public void localImage() {
        this.checkLocalImage(TestImages.TEST_LOCAL_IMAGE_1);
        this.checkLocalImage(TestImages.TEST_LOCAL_IMAGE_2);
        this.checkLocalImage(TestImages.TEST_LOCAL_IMAGE_3);
        this.checkLocalImage(TestImages.TEST_LOCAL_IMAGE_4);
    }

    private void checkLocalImage(ImageItem imageItem) {
        Image image = (Image)imageItem.get();
        RelImage wc = (RelImage)ResourceBuilders.IMAGE_BUILDER.getParam((ResourceItem)imageItem);
        Assert.assertEquals((double)image.getProgress(), (double)1.0, (double)0.0);
    }

    @Test
    public void webImage() {
        this.checkWebImage(TestImages.TEST_WEB_IMAGE_1);
        this.checkWebImage(TestImages.TEST_WEB_IMAGE_2);
        this.checkWebImage(TestImages.TEST_WEB_IMAGE_3);
    }

    private void checkWebImage(ImageItem imageItem) {
        Image image = (Image)imageItem.get();
        AbstractBaseParams wc = (AbstractBaseParams)ResourceBuilders.IMAGE_BUILDER.getParam((ResourceItem)imageItem);
        Assert.assertEquals((double)image.getProgress(), (double)1.0, (double)0.0);
    }

    @After
    public void tearDown() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }
}

