/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.resource.parameter;

import org.jrebirth.af.core.exception.CoreRuntimeException;
import org.jrebirth.af.core.log.JRLevel;
import org.jrebirth.af.core.log.JRebirthMarkers;
import org.jrebirth.af.core.resource.ResourceBuilders;
import org.jrebirth.af.core.resource.i18n.MessageResource;
import org.jrebirth.af.core.resource.parameter.ParameterItem;
import org.jrebirth.af.core.resource.parameter.ParameterMessages;
import org.jrebirth.af.core.resource.parameter.TestParameters;
import org.jrebirth.af.core.resource.provided.JRebirthParameters;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ParameterTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        ResourceBuilders.MESSAGE_BUILDER.searchMessagesFiles(".*_rb");
        ResourceBuilders.PARAMETER_BUILDER.searchConfigurationFiles(".*test-jrebirth", "properties");
        ParameterMessages.UNDEFINED_ENV_VAR.define(new MessageResource("Fatal Error ! environment variable {0} not found ", JRebirthMarkers.PARAMETER, JRLevel.Exception));
        JRebirthParameters.DEVELOPER_MODE.define((Object)true);
    }

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void stringParameter() {
        this.checkStringParameter(TestParameters.TEST_STRING_PARAM_1, "fonts");
        this.checkStringParameter(TestParameters.TEST_STRING_PARAM_2, "fontsFolder");
        this.checkStringParameter(TestParameters.TEST_STRING_PARAM_3, "font");
        this.checkStringParameter(TestParameters.TEST_STRING_PARAM_4, "fonts");
    }

    private void checkStringParameter(ParameterItem<String> parameterItem, String checkedName) {
        String param = (String)parameterItem.get();
        Assert.assertEquals((String)"Check String", (Object)checkedName, (Object)param);
    }

    @Test
    public void integerParameter() {
        this.checkIntegerParameter(TestParameters.TEST_INTEGER_WIDTH, 800);
    }

    private void checkIntegerParameter(ParameterItem<Integer> parameterItem, Integer checkedValue) {
        Integer param = (Integer)parameterItem.get();
        Assert.assertEquals((String)"Check Integer", (Object)checkedValue, (Object)param);
    }

    @Test
    public void overridableParameter() {
        TestParameters.OVERRIDABLE_PARAM.define((Object)2000);
        Assert.assertEquals((long)2000L, (long)((Integer)TestParameters.OVERRIDABLE_PARAM.get()).intValue());
        try {
            System.gc();
            Thread.sleep(500L);
            System.gc();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Assert.assertEquals((long)2000L, (long)((Integer)TestParameters.OVERRIDABLE_PARAM.get()).intValue());
    }

    @Test
    public void varenvParameter() {
        String tmp = System.getenv("TMP");
        junit.framework.Assert.assertEquals((String)tmp, (String)((String)TestParameters.VARENV_PARAM0.get()));
        junit.framework.Assert.assertEquals((String)(tmp + "/first"), (String)((String)TestParameters.VARENV_PARAM1.get()));
        junit.framework.Assert.assertEquals((String)(tmp + "/second"), (String)((String)TestParameters.VARENV_PARAM2.get()));
        junit.framework.Assert.assertEquals((String)(tmp + "/third"), (String)((String)TestParameters.VARENV_PARAM3.get()));
        junit.framework.Assert.assertEquals((String)(tmp + "/fourth"), (String)((String)TestParameters.VARENV_PARAM4.get()));
        this.thrown.expect(CoreRuntimeException.class);
        junit.framework.Assert.assertEquals((String)(tmp + "/fifth"), (String)((String)TestParameters.VARENV_PARAM5.get()));
    }

    @Test(expected=CoreRuntimeException.class)
    public void varenvParameterException() {
        junit.framework.Assert.assertEquals((String)"$TMP2/sixth", (String)((String)TestParameters.VARENV_PARAM6.get()));
    }

    @After
    public void tearDown() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }
}

