/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.ui.annotation;

import javafx.scene.control.Button;
import javafx.scene.control.ButtonBuilder;
import javafx.scene.layout.VBox;
import org.jrebirth.af.core.exception.CoreException;
import org.jrebirth.af.core.ui.DefaultView;
import org.jrebirth.af.core.ui.Model;
import org.jrebirth.af.core.ui.annotation.AnnotationController;
import org.jrebirth.af.core.ui.annotation.AnnotationModel;
import org.jrebirth.af.core.ui.annotation.OnRotate;
import org.jrebirth.af.core.ui.annotation.OnSwipe;

public final class AnnotationView
extends DefaultView<AnnotationModel, VBox, AnnotationController> {
    @OnSwipe(value={OnSwipe.SwipeType.Up, OnSwipe.SwipeType.Down})
    private Button swipeVerticalButton;
    @OnSwipe(value={OnSwipe.SwipeType.Left, OnSwipe.SwipeType.Right})
    private Button swipeHorizontalButton;
    @OnSwipe
    private Button swipeAllButton;
    @OnRotate
    private Button rotateAllButton;
    @OnRotate(value={OnRotate.RotateType.Rotate})
    private Button rotateButton;
    @OnRotate(value={OnRotate.RotateType.Started, OnRotate.RotateType.Finished})
    private Button rotateStartFinishButton;

    public AnnotationView(AnnotationModel model) throws CoreException {
        super((Model)model);
    }

    protected void initView() {
        ((VBox)this.getRootNode()).setMinWidth(200.0);
        this.swipeVerticalButton = ((ButtonBuilder)ButtonBuilder.create().text("Swipe Vertical Button")).build();
        this.swipeHorizontalButton = ((ButtonBuilder)ButtonBuilder.create().text("Swipe Horizontal Button")).build();
        this.swipeAllButton = ((ButtonBuilder)ButtonBuilder.create().text("Swipe All Button")).build();
        this.rotateAllButton = ((ButtonBuilder)ButtonBuilder.create().text("Rotate All Button")).build();
        this.rotateButton = ((ButtonBuilder)ButtonBuilder.create().text("Rotate Button")).build();
        this.rotateStartFinishButton = ((ButtonBuilder)ButtonBuilder.create().text("Rotate Started & Finished Button")).build();
        ((VBox)this.getRootNode()).getChildren().add((Object)this.swipeVerticalButton);
    }

    public Button getSwipeVerticalButton() {
        return this.swipeVerticalButton;
    }

    public Button getSwipeHorizontalButton() {
        return this.swipeHorizontalButton;
    }

    public Button getSwipeAllButton() {
        return this.swipeAllButton;
    }

    public Button getRotateAllButton() {
        return this.rotateAllButton;
    }

    public Button getRotateButton() {
        return this.rotateButton;
    }

    public Button getRotateStartFinishButton() {
        return this.rotateStartFinishButton;
    }
}

