/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.util;

import junit.framework.Assert;
import org.jrebirth.af.core.exception.CoreRuntimeException;
import org.jrebirth.af.core.resource.provided.JRebirthParameters;
import org.jrebirth.af.core.ui.DefaultModel;
import org.jrebirth.af.core.ui.NullView;
import org.jrebirth.af.core.util.CheckerUtility;
import org.jrebirth.af.core.wave.Wave;
import org.jrebirth.af.core.wave.WaveBuilder;
import org.jrebirth.af.core.wave.WaveData;
import org.jrebirth.af.core.wave.WaveItem;
import org.jrebirth.af.core.wave.WaveType;
import org.jrebirth.af.core.wave.WaveTypeBase;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class CheckerTest {
    WaveItem<String> StringItem = new WaveItem<String>(){};
    WaveItem<Integer> IntegerItem = new WaveItem<Integer>(){};
    WaveItem<Object> ObjectItem = new WaveItem<Object>(){};
    WaveType TYPE_0 = WaveTypeBase.build((String)"TYPE_0", (WaveItem[])new WaveItem[0]);
    WaveType TYPE_1 = WaveTypeBase.build((String)"TYPE_1", (WaveItem[])new WaveItem[]{this.StringItem});
    WaveType TYPE_2 = WaveTypeBase.build((String)"TYPE_2", (WaveItem[])new WaveItem[]{this.IntegerItem, this.StringItem});
    WaveType TYPE_3 = WaveTypeBase.build((String)"TYPE_3", (WaveItem[])new WaveItem[]{this.ObjectItem, this.IntegerItem, this.StringItem});
    WaveType TYPE_4 = WaveTypeBase.build((String)"TYPE_4", (WaveItem[])new WaveItem[]{this.IntegerItem, this.IntegerItem, this.IntegerItem});
    WaveType TYPE_5 = WaveTypeBase.build((String)"TYPE_5", (WaveItem[])new WaveItem[]{this.StringItem, this.IntegerItem, this.ObjectItem});
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() {
        JRebirthParameters.DEVELOPER_MODE.define((Object)true);
    }

    @Test
    public void checkWaveTypes() {
        this.checkWaveType(this.TYPE_0, null);
        this.checkWaveType(this.TYPE_1, null);
        this.checkWaveType(this.TYPE_2, null);
        this.checkWaveType(this.TYPE_3, null);
        this.checkWaveType(this.TYPE_4, null);
        this.checkWaveType(this.TYPE_5, CoreRuntimeException.class);
    }

    private void checkWaveType(WaveType type, Class<? extends Throwable> exceptionClass) {
        if (exceptionClass != null) {
            this.thrown.expect(exceptionClass);
        }
        CheckerUtility.checkWaveTypeContract(CheckerTestModel.class, (WaveType[])new WaveType[]{type});
        Assert.assertNull(exceptionClass);
    }

    @Test
    public void checkWave0() {
        this.checkWave((Wave)WaveBuilder.create().waveType(this.TYPE_0).build(), null);
    }

    @Test
    public void checkWave1() {
        this.checkWave((Wave)WaveBuilder.create().waveType(this.TYPE_1).data(new WaveData[]{WaveData.build(this.StringItem, (Object)"string")}).build(), null);
        this.checkWave((Wave)WaveBuilder.create().waveType(this.TYPE_1).data(new WaveData[]{WaveData.build(this.StringItem, (Object)"string"), WaveData.build(this.StringItem, (Object)"string")}).build(), null);
        this.checkWave((Wave)WaveBuilder.create().waveType(this.TYPE_1).build(), CoreRuntimeException.class);
        this.checkWave((Wave)WaveBuilder.create().waveType(this.TYPE_1).data(new WaveData[]{WaveData.build(this.IntegerItem, (Object)0)}).build(), CoreRuntimeException.class);
        this.checkWave((Wave)WaveBuilder.create().waveType(this.TYPE_1).data(new WaveData[]{WaveData.build(this.IntegerItem, (Object)0), WaveData.build(this.StringItem, (Object)"string")}).build(), null);
    }

    @Test
    public void checkWave2() {
        this.checkWave((Wave)WaveBuilder.create().waveType(this.TYPE_2).data(new WaveData[]{WaveData.build(this.StringItem, (Object)"string"), WaveData.build(this.IntegerItem, (Object)Integer.MIN_VALUE)}).build(), null);
        this.checkWave((Wave)WaveBuilder.create().waveType(this.TYPE_2).data(new WaveData[]{WaveData.build(this.StringItem, (Object)"string"), WaveData.build(this.IntegerItem, (Object)Integer.MIN_VALUE), WaveData.build(this.ObjectItem, (Object)new Object())}).build(), null);
        this.checkWave((Wave)WaveBuilder.create().waveType(this.TYPE_2).build(), CoreRuntimeException.class);
        this.checkWave((Wave)WaveBuilder.create().waveType(this.TYPE_2).data(new WaveData[]{WaveData.build(this.StringItem, (Object)"string")}).build(), CoreRuntimeException.class);
        this.checkWave((Wave)WaveBuilder.create().waveType(this.TYPE_1).data(new WaveData[]{WaveData.build(this.IntegerItem, (Object)0), WaveData.build(this.ObjectItem, (Object)new Object())}).build(), CoreRuntimeException.class);
        this.checkWave((Wave)WaveBuilder.create().waveType(this.TYPE_1).data(new WaveData[]{WaveData.build(this.ObjectItem, (Object)new Object()), WaveData.build(this.IntegerItem, (Object)0), WaveData.build(this.StringItem, (Object)"string")}).build(), null);
    }

    @Test
    public void checkWave3() {
        this.checkWave((Wave)WaveBuilder.create().waveType(this.TYPE_3).data(new WaveData[]{WaveData.build(this.StringItem, (Object)"string"), WaveData.build(this.IntegerItem, (Object)Integer.MIN_VALUE), WaveData.build(this.ObjectItem, (Object)new Object())}).build(), null);
    }

    @Test
    public void checkWave4() {
        this.checkWave((Wave)WaveBuilder.create().waveType(this.TYPE_4).data(new WaveData[]{WaveData.build(this.IntegerItem, (Object)42), WaveData.build(this.IntegerItem, (Object)Integer.MIN_VALUE), WaveData.build(this.IntegerItem, (Object)12)}).build(), null);
    }

    @Test
    public void checkWave5() {
        this.checkWave((Wave)WaveBuilder.create().waveType(this.TYPE_5).data(new WaveData[]{WaveData.build(this.StringItem, (Object)"string"), WaveData.build(this.IntegerItem, (Object)Integer.MIN_VALUE), WaveData.build(this.ObjectItem, (Object)new Object())}).build(), null);
    }

    private void checkWave(Wave wave, Class<? extends Throwable> exceptionClass) {
        if (exceptionClass != null) {
            this.thrown.expect(exceptionClass);
        }
        CheckerUtility.checkWave((Wave)wave);
        Assert.assertNull(exceptionClass);
    }

    public class CheckerTestModel
    extends DefaultModel<CheckerTestModel, NullView> {
        protected void initModel() {
            this.listen(new WaveType[]{CheckerTest.this.TYPE_0});
            this.listen(new WaveType[]{CheckerTest.this.TYPE_1});
            this.listen(new WaveType[]{CheckerTest.this.TYPE_2});
            this.listen(new WaveType[]{CheckerTest.this.TYPE_3});
            this.listen(new WaveType[]{CheckerTest.this.TYPE_4});
        }

        public void doType0(Wave wave) {
        }

        public void doType1(String item1, Wave wave) {
        }

        public void doType2(Integer item2, String item1, Wave wave) {
        }

        public void doType3(Object item3, Integer item2, String item1, Wave wave) {
        }

        public void doType4(Object item3, Object item2, Object item1, Wave wave) {
        }
    }
}

