/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.util;

import junit.framework.Assert;
import org.jrebirth.af.core.util.ObjectUtility;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectUtilTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectUtilTest.class);

    @Test
    public void equalsOrBothNull() {
        Object na = null;
        Object nb = null;
        String a = "a_string";
        String a2 = "a_string";
        String b = "b_string";
        Assert.assertTrue((String)"Null <=> Null", (boolean)ObjectUtility.equalsOrBothNull(na, nb));
        Assert.assertFalse((String)"A <=> Null", (boolean)ObjectUtility.equalsOrBothNull((Object)"a_string", nb));
        Assert.assertFalse((String)"Null <=> B", (boolean)ObjectUtility.equalsOrBothNull(na, (Object)"b_string"));
        Assert.assertFalse((String)"A <=> B", (boolean)ObjectUtility.equalsOrBothNull((Object)"a_string", (Object)"b_string"));
        Assert.assertFalse((String)"B <=> A", (boolean)ObjectUtility.equalsOrBothNull((Object)"b_string", (Object)"a_string"));
        Assert.assertTrue((String)"A <=> A'", (boolean)ObjectUtility.equalsOrBothNull((Object)"a_string", (Object)"a_string"));
        Assert.assertFalse((String)"B <=> A", (boolean)ObjectUtility.equalsOrBothNull((Object)"b_string", (Object)"a_string"));
        Assert.assertFalse((String)"B <=> A'", (boolean)ObjectUtility.equalsOrBothNull((Object)"b_string", (Object)"a_string"));
    }

    @Test
    public void notEquals() {
        Object na = null;
        Object nb = null;
        String a = "a_string";
        String a2 = "a_string";
        String b = "b_string";
        Assert.assertFalse((String)"Null </=/> Null", (boolean)ObjectUtility.notEquals(na, nb));
        Assert.assertTrue((String)"A </=/> Null", (boolean)ObjectUtility.notEquals((Object)"a_string", nb));
        Assert.assertTrue((String)"Null </=/> B", (boolean)ObjectUtility.notEquals(na, (Object)"b_string"));
        Assert.assertTrue((String)"A </=/> B", (boolean)ObjectUtility.notEquals((Object)"a_string", (Object)"b_string"));
        Assert.assertTrue((String)"B </=/> A", (boolean)ObjectUtility.notEquals((Object)"b_string", (Object)"a_string"));
        Assert.assertFalse((String)"A </=/> A'", (boolean)ObjectUtility.notEquals((Object)"a_string", (Object)"a_string"));
        Assert.assertTrue((String)"B </=/> A", (boolean)ObjectUtility.notEquals((Object)"b_string", (Object)"a_string"));
        Assert.assertTrue((String)"B </=/> A'", (boolean)ObjectUtility.notEquals((Object)"b_string", (Object)"a_string"));
    }
}

