/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.presentation.service;

import java.io.InputStreamReader;
import java.nio.charset.Charset;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jrebirth.af.core.service.DefaultService;
import org.jrebirth.af.presentation.resources.PrezParameters;
import org.jrebirth.presentation.model.Presentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PresentationService
extends DefaultService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PresentationService.class);
    private Presentation presentation;

    public void initService() {
        String configName = (String)PrezParameters.XML_FILE_LOCATION.get();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.jrebirth.presentation.model");
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            InputStreamReader in = new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream(configName + ".xml"), Charset.forName("UTF-8"));
            XMLStreamReader xsr = XMLInputFactory.newInstance().createXMLStreamReader(in);
            this.presentation = (Presentation)Presentation.class.cast(((JAXBElement)JAXBElement.class.cast(unmarshaller.unmarshal(xsr))).getValue());
        }
        catch (JAXBException | FactoryConfigurationError | XMLStreamException e) {
            LOGGER.error("Impossible to open {}.xml", (Object)configName, (Object)e);
        }
    }

    public Presentation getPresentation() {
        return this.presentation;
    }
}

