/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.presentation.ui.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.FadeTransitionBuilder;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransitionBuilder;
import javafx.animation.ScaleTransitionBuilder;
import javafx.animation.TimelineBuilder;
import javafx.animation.TranslateTransition;
import javafx.animation.TranslateTransitionBuilder;
import javafx.beans.value.WritableValue;
import javafx.scene.effect.Effect;
import javafx.scene.effect.MotionBlur;
import javafx.scene.effect.MotionBlurBuilder;
import javafx.util.Duration;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.core.ui.DefaultModel;
import org.jrebirth.af.presentation.ui.base.AbstractSlideView;
import org.jrebirth.af.presentation.ui.base.DefaultSlideStep;
import org.jrebirth.af.presentation.ui.base.SlideModel;
import org.jrebirth.af.presentation.ui.base.SlideStep;
import org.jrebirth.presentation.model.AnimationType;
import org.jrebirth.presentation.model.Slide;
import org.jrebirth.presentation.model.SlideContent;

public abstract class AbstractSlideModel<M extends AbstractSlideModel<M, V, S>, V extends AbstractSlideView<?, ?, ?>, S extends SlideStep>
extends DefaultModel<M, V>
implements SlideModel<S> {
    private Slide slide;
    private int stepPosition;
    private List<S> stepList;
    private int slideNumber;
    private Animation hideAnimation;
    private Animation showAnimation;
    private SlideFlow currentFlow = SlideFlow.forward;

    public Slide getSlide() {
        if (this.slide == null) {
            this.slide = (Slide)Slide.class.cast(this.getFirstKeyPart());
        }
        return this.slide;
    }

    public void setSlide(Slide slide) {
        this.slide = slide;
    }

    public SlideFlow getCurrentFlow() {
        return this.currentFlow;
    }

    public boolean isForwardFlow() {
        return this.currentFlow == SlideFlow.forward;
    }

    public void setCurrentFlow(SlideFlow currentFlow) {
        this.currentFlow = currentFlow;
    }

    protected void initModel() {
    }

    protected void bind() {
        super.bind();
        if (this.getStepList().size() > 0) {
            this.showSlideStep((SlideStep)this.getStepList().get(this.stepPosition));
        }
    }

    protected void initInnerComponents() {
    }

    protected void showView() {
    }

    protected void hideView() {
    }

    protected void processWave(Wave wave) {
    }

    public int getSlideNumber() {
        return this.slideNumber;
    }

    @Override
    public void setSlideNumber(int slideNumber) {
        this.slideNumber = slideNumber;
    }

    public int getStepPosition() {
        return this.stepPosition;
    }

    public boolean hasStep() {
        return !this.getStepList().isEmpty();
    }

    private List<S> getStepList() {
        if (this.stepList == null) {
            this.stepList = new ArrayList<S>();
            this.stepList.addAll(Arrays.asList(this.initializeSlideStep()));
            for (SlideContent sc : this.getSlide().getContent()) {
                if (this.hasStep(sc)) continue;
                if (sc.getIndex() != null) {
                    this.stepList.add(sc.getIndex().intValue(), new DefaultSlideStep(sc.getName()));
                    continue;
                }
                this.stepList.add(new DefaultSlideStep(sc.getName()));
            }
        }
        return this.stepList;
    }

    private boolean hasStep(SlideContent slideContent) {
        boolean res = false;
        for (SlideStep step : this.stepList) {
            if (!step.name().equalsIgnoreCase(slideContent.getName())) continue;
            res = true;
        }
        return res;
    }

    protected abstract S[] initializeSlideStep();

    @Override
    public boolean nextStep() {
        boolean res;
        boolean bl = res = this.stepPosition < this.stepList.size() - 1;
        if (res && !((AbstractSlideView)this.getView()).isSlideLocked()) {
            this.setCurrentFlow(SlideFlow.forward);
            ++this.stepPosition;
            this.showSlideStep((SlideStep)this.getStepList().get(this.stepPosition));
        }
        return !res;
    }

    @Override
    public boolean previousStep() {
        boolean res;
        boolean bl = res = this.stepPosition > 0;
        if (res && !((AbstractSlideView)this.getView()).isSlideLocked()) {
            this.setCurrentFlow(SlideFlow.backward);
            --this.stepPosition;
            this.showSlideStep((SlideStep)this.getStepList().get(this.stepPosition));
        }
        return !res;
    }

    public SlideContent getDefaultContent() {
        SlideContent res = null;
        if (this.getSlide().getContent() != null && !this.getSlide().getContent().isEmpty()) {
            res = this.getSlide().getContent().get(0);
        }
        return res;
    }

    public SlideContent getContent(SlideStep slideStep) {
        SlideContent res = null;
        if (this.getSlide().getContent() != null && !this.getSlide().getContent().isEmpty()) {
            for (SlideContent sc : this.getSlide().getContent()) {
                if (sc.getName() == null || sc.getName().isEmpty() || !sc.getName().equals(slideStep.name())) continue;
                res = sc;
            }
        }
        return res == null ? this.getDefaultContent() : res;
    }

    @Override
    public abstract void showSlideStep(S var1);

    @Override
    public Animation getShowAnimation() {
        if (this.showAnimation == null) {
            this.showAnimation = this.buildAnimation(this.getSlide().getShowAnimation());
        }
        return this.showAnimation;
    }

    @Override
    public Animation getHideAnimation() {
        if (this.hideAnimation == null) {
            this.hideAnimation = this.buildAnimation(this.getSlide().getHideAnimation());
        }
        return this.hideAnimation;
    }

    private Animation buildAnimation(AnimationType animationType) {
        Animation animation = null;
        switch (animationType) {
            case MOVE_TO_RIGHT: {
                animation = this.buildHorizontalAnimation(0.0, 2000.0, 0.0, 0.0);
                break;
            }
            case MOVE_TO_LEFT: {
                animation = this.buildHorizontalAnimation(0.0, -2000.0, 0.0, 0.0);
                break;
            }
            case MOVE_TO_TOP: {
                animation = this.buildHorizontalAnimation(0.0, 0.0, 0.0, -1000.0);
                break;
            }
            case MOVE_TO_BOTTOM: {
                animation = this.buildHorizontalAnimation(0.0, 0.0, 0.0, 1000.0);
                break;
            }
            case MOVE_FROM_RIGHT: {
                animation = this.buildHorizontalAnimation(2000.0, 0.0, 0.0, 0.0);
                break;
            }
            case MOVE_FROM_LEFT: {
                animation = this.buildHorizontalAnimation(-2000.0, 0.0, 0.0, 0.0);
                break;
            }
            case MOVE_FROM_TOP: {
                animation = this.buildHorizontalAnimation(0.0, 0.0, -1000.0, 0.0);
                break;
            }
            case MOVE_FROM_BOTTOM: {
                animation = this.buildHorizontalAnimation(0.0, 0.0, 1000.0, 0.0);
                break;
            }
            case FADE_IN: {
                animation = FadeTransitionBuilder.create().node(this.getRootNode()).fromValue(0.0).toValue(1.0).duration(Duration.seconds((double)1.0)).build();
                break;
            }
            case FADE_OUT: {
                animation = FadeTransitionBuilder.create().node(this.getRootNode()).fromValue(1.0).toValue(0.0).duration(Duration.seconds((double)1.0)).build();
                break;
            }
            case SCALE_FROM_MAX: {
                animation = this.buildScaleAnimation(20.0, 1.0, true);
                break;
            }
            case SCALE_FROM_MIN: {
                animation = this.buildScaleAnimation(0.0, 1.0, true);
                break;
            }
            case SCALE_TO_MAX: {
                animation = this.buildScaleAnimation(1.0, 20.0, false);
                break;
            }
            case SCALE_TO_MIN: {
                animation = this.buildScaleAnimation(1.0, 0.0, false);
                break;
            }
            case SLIDING_TOP_BOTTOM_PROGRESSIVE: {
                animation = this.buildSliding();
                break;
            }
            case TILE_IN: {
                break;
            }
            case TILE_OUT: {
                break;
            }
            case TILE_IN_60_K: {
                break;
            }
            case TILE_OUT_60_K: {
                break;
            }
        }
        return animation;
    }

    private Animation buildSliding() {
        return new TranslateTransition();
    }

    private Animation buildScaleAnimation(double from, double to, boolean show) {
        return ParallelTransitionBuilder.create().children(new Animation[]{ScaleTransitionBuilder.create().node(this.getRootNode()).fromX(from).toX(to).fromY(from).toY(to).duration(Duration.seconds((double)1.0)).build(), FadeTransitionBuilder.create().node(this.getRootNode()).fromValue(show ? 0.0 : 1.0).toValue(show ? 1.0 : 0.0).duration(Duration.seconds((double)1.0)).build()}).build();
    }

    protected Animation buildHorizontalAnimation(double fromX, double toX, double fromY, double toY) {
        double angle = this.findAngle(fromX, toX, fromY, toY);
        MotionBlur mb = MotionBlurBuilder.create().angle(angle).build();
        this.getRootNode().setEffect((Effect)mb);
        return ParallelTransitionBuilder.create().children(new Animation[]{TranslateTransitionBuilder.create().node(this.getRootNode()).fromX(fromX).toX(toX).fromY(fromY).toY(toY).duration(Duration.seconds((double)1.0)).build(), TimelineBuilder.create().keyFrames(new KeyFrame[]{new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)mb.radiusProperty(), (Object)0)}), new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{new KeyValue((WritableValue)mb.radiusProperty(), (Object)50)}), new KeyFrame(Duration.millis((double)500.0), new KeyValue[]{new KeyValue((WritableValue)mb.radiusProperty(), (Object)63)}), new KeyFrame(Duration.millis((double)900.0), new KeyValue[]{new KeyValue((WritableValue)mb.radiusProperty(), (Object)50)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)mb.radiusProperty(), (Object)0)})}).build()}).build();
    }

    private double findAngle(double fromX, double fromY, double toX, double toY) {
        double angle;
        double yDelta = toY - fromY;
        double y = Math.sin(yDelta) * Math.cos(toX);
        double x = Math.cos(fromX) * Math.sin(toX) - Math.sin(fromX) * Math.cos(toX) * Math.cos(yDelta);
        for (angle = Math.toDegrees(Math.atan2(y, x)); angle < 0.0; angle += 360.0) {
        }
        return (float)angle % 360.0f;
    }

    public static enum SlideFlow {
        forward,
        backward;

    }
}

