/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.presentation.ui.image;

import java.util.ArrayList;
import java.util.Random;
import javafx.animation.Animation;
import javafx.animation.FadeTransitionBuilder;
import javafx.animation.ParallelTransitionBuilder;
import javafx.animation.PauseTransitionBuilder;
import javafx.animation.SequentialTransition;
import javafx.animation.SequentialTransitionBuilder;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.ImageViewBuilder;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.RectangleBuilder;
import javafx.util.Duration;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.resource.image.ImageParams;
import org.jrebirth.af.core.resource.Resources;
import org.jrebirth.af.core.resource.image.RelImage;
import org.jrebirth.af.presentation.ui.base.AbstractSlideView;
import org.jrebirth.af.presentation.ui.image.ImageSlideController;
import org.jrebirth.af.presentation.ui.image.ImageSlideModel;
import org.jrebirth.presentation.model.AnimationType;

public final class ImageSlideView
extends AbstractSlideView<ImageSlideModel, StackPane, ImageSlideController> {
    private static final Random RANDOM = new Random();
    private Animation tileTransition;
    private Animation fadeTransition;
    private Image image;
    private int tilePerRow = 50;

    public ImageSlideView(ImageSlideModel model) throws CoreException {
        super(model);
    }

    protected void initView() {
        this.image = Resources.create((ImageParams)new RelImage(((ImageSlideModel)this.getModel()).getImage())).get();
        if (((ImageSlideModel)this.getModel()).getSlide().getShowAnimation() == null || !"Tile".equalsIgnoreCase(((ImageSlideModel)this.getModel()).getSlide().getShowAnimation().name()) && !"Tile_60_k".equalsIgnoreCase(((ImageSlideModel)this.getModel()).getSlide().getShowAnimation().name())) {
            ((StackPane)this.getRootNode()).getChildren().add((Object)((ImageViewBuilder)((ImageViewBuilder)ImageViewBuilder.create().image(this.image).layoutX(0.0)).layoutY(0.0)).fitWidth(this.image.getWidth()).fitHeight(this.image.getHeight()).build());
        }
        this.getTileTransition();
        this.getFadeTransition();
    }

    Image getImage() {
        return this.image;
    }

    public void start() {
        if (((ImageSlideModel)this.getModel()).getSlide().getShowAnimation() != null && AnimationType.TILE_IN == ((ImageSlideModel)this.getModel()).getSlide().getShowAnimation()) {
            for (Node n : ((StackPane)this.getRootNode()).getChildren()) {
                n.setOpacity(0.0);
            }
            this.tilePerRow = 5;
            this.getTileTransition().play();
        } else if (((ImageSlideModel)this.getModel()).getSlide().getShowAnimation() != null && AnimationType.TILE_IN_60_K == ((ImageSlideModel)this.getModel()).getSlide().getShowAnimation()) {
            for (Node n : ((StackPane)this.getRootNode()).getChildren()) {
                n.setOpacity(0.0);
            }
            this.tilePerRow = 50;
            this.getTileTransition().play();
        } else {
            ((StackPane)this.getRootNode()).setOpacity(0.0);
            this.getFadeTransition().play();
        }
    }

    Animation getFadeTransition() {
        if (this.fadeTransition == null) {
            this.fadeTransition = FadeTransitionBuilder.create().node(this.getRootNode()).fromValue(0.0).toValue(1.0).duration(Duration.seconds((double)1.0)).build();
        }
        return this.fadeTransition;
    }

    Animation getTileTransition() {
        if (this.tileTransition == null) {
            double width = this.getImage().getWidth();
            double height = this.getImage().getHeight();
            double tileWidth = width / (double)this.tilePerRow;
            double tileHeight = height / (double)this.tilePerRow;
            ArrayList<SequentialTransition> fades = new ArrayList<SequentialTransition>();
            for (double x = 0.0; x < width; x += tileWidth) {
                for (double y = 0.0; y < height; y += tileHeight) {
                    ImageView iv = ((ImageViewBuilder)((ImageViewBuilder)((ImageViewBuilder)((ImageViewBuilder)ImageViewBuilder.create().image(this.getImage()).clip((Node)RectangleBuilder.create().x(x).y(y).width(tileWidth).height(tileHeight).build())).opacity(0.0)).layoutX(x)).layoutY(y)).build();
                    ((StackPane)this.getRootNode()).getChildren().add((Object)iv);
                    fades.add(SequentialTransitionBuilder.create().children(new Animation[]{PauseTransitionBuilder.create().duration(this.getRandomDuration()).build(), FadeTransitionBuilder.create().node((Node)iv).fromValue(0.0).toValue(1.0).duration(this.getRandomDuration()).build()}).build());
                }
            }
            this.tileTransition = ParallelTransitionBuilder.create().children(fades).build();
            this.tileTransition.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent arg0) {
                    for (Node n : ((StackPane)ImageSlideView.this.getRootNode()).getChildren()) {
                        n.setOpacity(1.0);
                    }
                }
            });
        }
        return this.tileTransition;
    }

    private Duration getRandomDuration() {
        return Duration.millis((double)(Math.abs(RANDOM.nextLong()) % 900L + 300L));
    }

    public void reload() {
    }

    public void hide() {
    }
}

