/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.presentation.ui.stack;

import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.scene.control.Control;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.SwipeEvent;
import javafx.scene.web.WebView;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.ui.View;
import org.jrebirth.af.api.wave.contract.WaveData;
import org.jrebirth.af.core.ui.DefaultController;
import org.jrebirth.af.core.ui.adapter.ActionAdapter;
import org.jrebirth.af.presentation.command.ShowNextSlideCommand;
import org.jrebirth.af.presentation.command.ShowPreviousSlideCommand;
import org.jrebirth.af.presentation.command.ShowSlideMenuCommand;
import org.jrebirth.af.presentation.ui.stack.SlideStackModel;
import org.jrebirth.af.presentation.ui.stack.SlideStackView;

public final class SlideStackController
extends DefaultController<SlideStackModel, SlideStackView>
implements ActionAdapter {
    public SlideStackController(SlideStackView view) throws CoreException {
        super((View)view);
    }

    protected void initEventHandlers() throws CoreException {
        ((SlideStackView)this.getView()).getCircle().setOnAction(this.getHandler(ActionEvent.ACTION));
    }

    protected void onKeyPressed(KeyEvent keyEvent) {
        System.out.println("Key " + keyEvent);
        if (keyEvent.getCode() == KeyCode.PAGE_DOWN) {
            ((SlideStackModel)this.getModel()).callCommand(ShowNextSlideCommand.class, new WaveData[0]);
            keyEvent.consume();
        } else if (keyEvent.getCode() == KeyCode.PAGE_UP) {
            ((SlideStackModel)this.getModel()).callCommand(ShowPreviousSlideCommand.class, new WaveData[0]);
            keyEvent.consume();
        }
    }

    protected void onMouseReleased(MouseEvent mouseEvent) {
        System.out.println("Mouse " + mouseEvent);
        if (!(mouseEvent.getTarget() instanceof Control) && !(mouseEvent.getTarget() instanceof WebView)) {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                ((SlideStackModel)this.getModel()).callCommand(ShowNextSlideCommand.class, new WaveData[0]);
                mouseEvent.consume();
            } else if (mouseEvent.getButton() == MouseButton.SECONDARY) {
                ((SlideStackModel)this.getModel()).callCommand(ShowPreviousSlideCommand.class, new WaveData[0]);
                mouseEvent.consume();
            } else if (mouseEvent.getButton() == MouseButton.MIDDLE) {
                ((SlideStackModel)this.getModel()).callCommand(ShowSlideMenuCommand.class, new WaveData[0]);
                mouseEvent.consume();
            }
        }
    }

    protected void onSwipeLeft(SwipeEvent swipeEvent) {
        System.out.println("swipe left");
        ((SlideStackView)this.getView()).getCircle().fireEvent((Event)new ActionEvent());
        ((SlideStackModel)this.getModel()).callCommand(ShowNextSlideCommand.class, new WaveData[0]);
        swipeEvent.consume();
    }

    protected void onSwipeRight(SwipeEvent swipeEvent) {
        System.out.println("swipe right");
        ((SlideStackModel)this.getModel()).callCommand(ShowPreviousSlideCommand.class, new WaveData[0]);
        swipeEvent.consume();
    }

    public void action(ActionEvent actionEvent) {
        System.err.println("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
    }
}

