/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.presentation.ui.stack;

import java.util.List;
import javafx.animation.Animation;
import javafx.animation.ParallelTransition;
import javafx.animation.ParallelTransitionBuilder;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.core.ui.DefaultModel;
import org.jrebirth.af.presentation.service.PresentationService;
import org.jrebirth.af.presentation.ui.base.SlideModel;
import org.jrebirth.af.presentation.ui.base.SlideStep;
import org.jrebirth.af.presentation.ui.stack.SlideStackView;
import org.jrebirth.presentation.model.Slide;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SlideStackModel
extends DefaultModel<SlideStackModel, SlideStackView> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlideStackModel.class);
    private int slidePosition;
    private Slide selectedSlide;
    private SlideModel<SlideStep> selectedSlideModel;
    private PresentationService presentationService;

    protected void initModel() {
        List<Slide> slideList = this.getPresentationService().getPresentation().getSlides().getSlide();
        if (!slideList.isEmpty()) {
            this.slidePosition = 0;
            this.displaySlide(slideList.get(this.slidePosition), false);
        }
    }

    protected void initInnerComponents() {
    }

    protected void showView() {
    }

    protected void hideView() {
    }

    protected void processWave(Wave wave) {
    }

    protected PresentationService getPresentationService() {
        if (this.presentationService == null) {
            this.presentationService = (PresentationService)this.getService(PresentationService.class, new Object[0]);
        }
        return this.presentationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displaySlide(Slide slide, boolean isReverse) {
        SlideStackModel slideStackModel = this;
        synchronized (slideStackModel) {
            try {
                LOGGER.trace("Display slide N\u00b0" + slide.getPage() + " reverse=" + isReverse);
                SlideModel previousSlideModel = null;
                if (this.selectedSlide != null) {
                    Class<?> previousClass = this.selectedSlide.getModelClass() == null ? Class.forName(this.getPresentationService().getPresentation().getSlides().getDefaultModelClass()) : Class.forName(this.selectedSlide.getModelClass());
                    previousSlideModel = (SlideModel)this.getModel(previousClass, new Object[]{this.selectedSlide});
                }
                slide.setPage(this.slidePosition);
                Class<?> nextClass = slide.getModelClass() == null ? Class.forName(this.getPresentationService().getPresentation().getSlides().getDefaultModelClass()) : Class.forName(slide.getModelClass());
                this.selectedSlideModel = (SlideModel)this.getModel(nextClass, new Object[]{slide});
                if (!((StackPane)((SlideStackView)this.getView()).getRootNode()).getChildren().contains((Object)this.selectedSlideModel.getRootNode())) {
                    ((StackPane)((SlideStackView)this.getView()).getRootNode()).getChildren().add((Object)this.selectedSlideModel.getRootNode());
                }
                ParallelTransition slideAnimation = this.buildSlideTransition(isReverse, previousSlideModel, this.selectedSlideModel);
                if (isReverse) {
                    slideAnimation.setRate(-1.0);
                    slideAnimation.playFrom(slideAnimation.getCycleDuration());
                } else {
                    slideAnimation.setRate(1.0);
                    slideAnimation.playFromStart();
                }
                this.selectedSlide = slide;
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Error while loading a slide", (Throwable)e);
            }
        }
    }

    private ParallelTransition buildSlideTransition(boolean isReverse, final SlideModel<SlideStep> previousSlideModel, final SlideModel<SlideStep> selectedSlideModel) {
        Animation a;
        ParallelTransition slideAnimation = ParallelTransitionBuilder.create().build();
        if (previousSlideModel != null) {
            Animation animation = a = isReverse ? previousSlideModel.getShowAnimation() : previousSlideModel.getHideAnimation();
            if (a != null) {
                slideAnimation.getChildren().add((Object)a);
            }
        }
        if (this.selectedSlideModel != null) {
            Animation animation = a = isReverse ? this.selectedSlideModel.getHideAnimation() : this.selectedSlideModel.getShowAnimation();
            if (a != null) {
                slideAnimation.getChildren().add((Object)a);
            }
        }
        final SlideModel<SlideStep> csm = selectedSlideModel;
        final SlideModel<SlideStep> psm = previousSlideModel;
        slideAnimation.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                if (previousSlideModel != null) {
                    previousSlideModel.doHideView(null);
                }
                if (selectedSlideModel != null) {
                    selectedSlideModel.doShowView(null);
                }
                if (psm != null) {
                    for (int i = ((StackPane)((SlideStackView)SlideStackModel.this.getView()).getRootNode()).getChildren().size() - 1; i > 0; --i) {
                        Node node = (Node)((StackPane)((SlideStackView)SlideStackModel.this.getView()).getRootNode()).getChildren().get(i);
                        if (csm.getRootNode() == node) continue;
                        ((StackPane)((SlideStackView)SlideStackModel.this.getView()).getRootNode()).getChildren().remove((Object)node);
                    }
                }
            }
        });
        return slideAnimation;
    }

    public int getSlidePosition() {
        return this.slidePosition;
    }

    public void setSlidePosition(int slidePosition) {
        this.slidePosition = slidePosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void next() {
        SlideStackModel slideStackModel = this;
        synchronized (slideStackModel) {
            if (this.selectedSlideModel.nextStep() && this.slidePosition < this.getPresentationService().getPresentation().getSlides().getSlide().size() - 1) {
                this.slidePosition = Math.min(this.slidePosition + 1, this.getPresentationService().getPresentation().getSlides().getSlide().size() - 1);
                this.displaySlide(this.getPresentationService().getPresentation().getSlides().getSlide().get(this.slidePosition), false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void previous() {
        SlideStackModel slideStackModel = this;
        synchronized (slideStackModel) {
            if (this.selectedSlideModel.previousStep() && this.slidePosition > 0) {
                this.slidePosition = Math.max(this.slidePosition - 1, 0);
                this.displaySlide(this.getPresentationService().getPresentation().getSlides().getSlide().get(this.slidePosition), true);
            }
        }
    }

    public void showSlideMenu() {
    }
}

