/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.presentation.ui.template;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.ParallelTransitionBuilder;
import javafx.animation.RotateTransitionBuilder;
import javafx.animation.ScaleTransitionBuilder;
import javafx.animation.SequentialTransitionBuilder;
import javafx.animation.TimelineBuilder;
import javafx.animation.TranslateTransitionBuilder;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.NumberBinding;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.HyperlinkBuilder;
import javafx.scene.control.Label;
import javafx.scene.control.LabelBuilder;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.ImageViewBuilder;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.AnchorPaneBuilder;
import javafx.scene.layout.Pane;
import javafx.scene.layout.PaneBuilder;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.StackPaneBuilder;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.CircleBuilder;
import javafx.scene.shape.Polyline;
import javafx.scene.shape.PolylineBuilder;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.RectangleBuilder;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextBuilder;
import javafx.scene.web.WebView;
import javafx.scene.web.WebViewBuilder;
import javafx.util.Duration;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.resource.image.ImageParams;
import org.jrebirth.af.core.resource.Resources;
import org.jrebirth.af.core.resource.image.RelImage;
import org.jrebirth.af.presentation.resources.PrezColors;
import org.jrebirth.af.presentation.resources.PrezFonts;
import org.jrebirth.af.presentation.resources.PrezImages;
import org.jrebirth.af.presentation.ui.base.AbstractSlideView;
import org.jrebirth.af.presentation.ui.base.SlideStep;
import org.jrebirth.af.presentation.ui.template.AbstractTemplateController;
import org.jrebirth.af.presentation.ui.template.AbstractTemplateModel;
import org.jrebirth.presentation.model.SlideContent;
import org.jrebirth.presentation.model.SlideItem;

public abstract class AbstractTemplateView<M extends AbstractTemplateModel<?, ?, ?>, N extends AnchorPane, C extends AbstractTemplateController<?, ?>>
extends AbstractSlideView<M, N, C> {
    private static final String ITEM_CLASS_PREFIX = "item";
    private Label secondaryTitle;
    private Label pageLabel;
    private StackPane slideContent;
    private final List<Node> subSlides = new ArrayList<Node>();
    private Node currentSubSlide;
    private Circle circle;
    private Rectangle rectangle;

    public AbstractTemplateView(M model) throws CoreException {
        super(model);
    }

    protected Label getSubTitle() {
        return this.secondaryTitle;
    }

    protected void initView() {
        super.initView();
        this.slideContent = new StackPane();
        this.slideContent.getStyleClass().add((Object)"content");
        this.slideContent.setMinSize(952.0, 642.0);
        this.slideContent.setMaxSize(952.0, 642.0);
        this.slideContent.setPrefSize(952.0, 642.0);
        if (!((AbstractTemplateModel)this.getModel()).hasStep()) {
            this.addSubSlide(this.getContentPanel());
        }
        this.slideContent.setScaleX(0.0);
        this.slideContent.setScaleY(0.0);
        this.slideContent.setRotate(-180.0);
        Node header = this.getHeaderPanel();
        AnchorPane.setTopAnchor((Node)header, (Double)0.0);
        AnchorPane.setTopAnchor((Node)this.slideContent, (Double)109.0);
        AnchorPane.setLeftAnchor((Node)this.slideContent, (Double)48.0);
        ((AnchorPane)this.getRootNode()).getChildren().addAll((Object[])new Node[]{this.slideContent, header});
    }

    protected void showEmptySlide() {
        this.subSlides.add(((AbstractTemplateModel)this.getModel()).getStepPosition(), null);
    }

    private void addSubSlide(Node defaultSubSlide) {
        this.subSlides.add(((AbstractTemplateModel)this.getModel()).getStepPosition(), defaultSubSlide);
        this.slideContent.getChildren().add((Object)defaultSubSlide);
        StackPane.setAlignment((Node)defaultSubSlide, (Pos)Pos.CENTER);
    }

    public void start() {
        this.reload();
    }

    public void reload() {
        ParallelTransitionBuilder.create().children(new Animation[]{ScaleTransitionBuilder.create().node((Node)this.circle).duration(Duration.millis((double)600.0)).fromX(0.0).fromY(0.0).toX(1.0).toY(1.0).build(), ((TimelineBuilder)TimelineBuilder.create().delay(Duration.millis((double)200.0))).keyFrames(new KeyFrame[]{new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.rectangle.widthProperty(), (Object)0)}), new KeyFrame(Duration.millis((double)600.0), new KeyValue[]{new KeyValue((WritableValue)this.rectangle.widthProperty(), (Object)90)})}).build(), ((ParallelTransitionBuilder)ParallelTransitionBuilder.create().delay(Duration.millis((double)400.0))).children(new Animation[]{RotateTransitionBuilder.create().duration(Duration.millis((double)600.0)).fromAngle(-180.0).toAngle(0.0).build(), ScaleTransitionBuilder.create().duration(Duration.millis((double)600.0)).fromX(0.0).fromY(0.0).toX(1.0).toY(1.0).build()}).node((Node)this.slideContent).build()}).build().play();
    }

    protected Node getHeaderPanel() {
        Pane headerPane = ((PaneBuilder)((PaneBuilder)((PaneBuilder)((PaneBuilder)((PaneBuilder)PaneBuilder.create().styleClass(new String[]{"header"})).layoutX(0.0)).layoutY(0.0)).minWidth(1024.0)).prefWidth(1024.0)).build();
        Label primaryTitle = ((LabelBuilder)((LabelBuilder)((LabelBuilder)((LabelBuilder)((LabelBuilder)LabelBuilder.create().font(PrezFonts.SLIDE_TITLE.get())).textFill((Paint)PrezColors.SLIDE_TITLE.get())).text(((AbstractTemplateModel)this.getModel()).getSlide().getTitle().replaceAll("\\\\n", "\n").replaceAll("\\\\t", "\t"))).layoutX(40.0)).layoutY(45.0)).build();
        this.secondaryTitle = ((LabelBuilder)((LabelBuilder)((LabelBuilder)((LabelBuilder)((LabelBuilder)((LabelBuilder)((LabelBuilder)LabelBuilder.create().font(PrezFonts.SLIDE_SUB_TITLE.get())).textFill((Paint)PrezColors.SLIDE_TITLE.get())).layoutX(450.0)).layoutY(14.0)).minWidth(450.0)).alignment(Pos.CENTER_RIGHT)).textAlignment(TextAlignment.RIGHT)).build();
        ImageView breizhcamp = ((ImageViewBuilder)((ImageViewBuilder)((ImageViewBuilder)((ImageViewBuilder)ImageViewBuilder.create().layoutX(680.0)).layoutY(-14.0)).scaleX(0.6)).scaleY(0.6)).image(PrezImages.HEADER_LOGO.get()).build();
        Polyline pl = ((PolylineBuilder)((PolylineBuilder)PolylineBuilder.create().strokeWidth(3.0)).stroke((Paint)Color.BLACK)).points(new Double[]{684.0, 12.0, 946.0, 12.0, 946.0, 107.0}).build();
        this.rectangle = ((RectangleBuilder)((RectangleBuilder)((RectangleBuilder)RectangleBuilder.create().layoutX(108.0)).layoutY(95.0)).width(0.0).height(14.0).fill((Paint)Color.web((String)"1C9A9A"))).build();
        this.circle = ((CircleBuilder)((CircleBuilder)((CircleBuilder)((CircleBuilder)((CircleBuilder)CircleBuilder.create().scaleX(0.0)).scaleY(0.0)).layoutX(72.0)).layoutY(72.0)).radius(54.0).fill((Paint)Color.web((String)"444442"))).build();
        this.pageLabel = ((LabelBuilder)((LabelBuilder)((LabelBuilder)((LabelBuilder)((LabelBuilder)LabelBuilder.create().layoutX(970.0)).layoutY(18.0)).text(String.valueOf(((AbstractTemplateModel)this.getModel()).getSlide().getPage()))).font(PrezFonts.PAGE.get())).rotate(90.0)).build();
        headerPane.getChildren().addAll((Object[])new Node[]{this.circle, primaryTitle, breizhcamp, this.secondaryTitle, pl, this.rectangle, this.pageLabel});
        return headerPane;
    }

    protected void bindNode(Node node) {
        node.scaleXProperty().bind((ObservableValue)this.bindWidth());
        node.scaleYProperty().bind((ObservableValue)this.bindHeight());
    }

    protected NumberBinding bindHeight() {
        return Bindings.divide((ObservableNumberValue)((AbstractTemplateModel)this.getModel()).getLocalFacade().getGlobalFacade().getApplication().getStage().heightProperty(), (int)768);
    }

    protected NumberBinding bindWidth() {
        return Bindings.divide((ObservableNumberValue)((AbstractTemplateModel)this.getModel()).getLocalFacade().getGlobalFacade().getApplication().getStage().widthProperty(), (int)1024);
    }

    protected abstract Node getContentPanel();

    protected Node getFooterPanel() {
        this.pageLabel = ((LabelBuilder)((LabelBuilder)LabelBuilder.create().text(String.valueOf(((AbstractTemplateModel)this.getModel()).getSlide().getPage()))).font(PrezFonts.PAGE.get())).build();
        AnchorPane ap = ((AnchorPaneBuilder)AnchorPaneBuilder.create().children(new Node[]{this.pageLabel})).build();
        AnchorPane.setRightAnchor((Node)this.pageLabel, (Double)20.0);
        StackPane sp = ((StackPaneBuilder)((StackPaneBuilder)((StackPaneBuilder)((StackPaneBuilder)((StackPaneBuilder)StackPaneBuilder.create().styleClass(new String[]{"footer"})).prefHeight(35.0)).minHeight(Double.NEGATIVE_INFINITY)).maxHeight(Double.NEGATIVE_INFINITY)).children(new Node[]{ap})).build();
        StackPane.setAlignment((Node)ap, (Pos)Pos.CENTER_RIGHT);
        return sp;
    }

    protected VBox buildDefaultContent(SlideContent slideContent) {
        VBox vbox = new VBox();
        if (((AbstractTemplateModel)this.getModel()).getSlide().getStyle() != null) {
            vbox.getStyleClass().add((Object)((AbstractTemplateModel)this.getModel()).getSlide().getStyle());
        }
        if (slideContent != null) {
            for (SlideItem item : slideContent.getItem()) {
                this.addSlideItem(vbox, item);
            }
            if (slideContent.getTitle() != null) {
                this.secondaryTitle.setText(slideContent.getTitle());
            }
        }
        return vbox;
    }

    protected void addSlideItem(VBox vbox, SlideItem item) {
        WebView node = null;
        if (item.isLink()) {
            Hyperlink link = ((HyperlinkBuilder)((HyperlinkBuilder)HyperlinkBuilder.create().opacity(1.0)).text(item.getValue())).build();
            link.getStyleClass().add((Object)("link" + item.getLevel()));
            link.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    ClipboardContent content = new ClipboardContent();
                    content.putString("http://" + ((Hyperlink)e.getSource()).getText());
                    Clipboard.getSystemClipboard().setContent((Map)content);
                }
            });
            node = link;
        } else if (item.isHtml()) {
            WebView web = WebViewBuilder.create().fontScale(1.4).build();
            web.getEngine().loadContent(item.getValue());
            VBox.setVgrow((Node)web, (Priority)Priority.NEVER);
            node = web;
        } else if (item.getImage() != null) {
            Image image = Resources.create((ImageParams)new RelImage(item.getImage())).get();
            ImageView imageViewer = ((ImageViewBuilder)ImageViewBuilder.create().styleClass(new String[]{ITEM_CLASS_PREFIX + item.getLevel()})).image(image).build();
            node = imageViewer;
        } else {
            Text text = ((TextBuilder)TextBuilder.create().styleClass(new String[]{ITEM_CLASS_PREFIX + item.getLevel()})).text(item.getValue() == null ? "" : item.getValue()).build();
            node = text;
        }
        if (item.getStyle() != null) {
            node.getStyleClass().add((Object)item.getStyle());
        }
        if (item.getScale() != 1.0) {
            node.setScaleX(item.getScale());
            node.setScaleY(item.getScale());
        }
        vbox.getChildren().add((Object)node);
    }

    public void showSlideStep(SlideStep slideStep) {
        if (this.subSlides.size() >= ((AbstractTemplateModel)this.getModel()).getStepPosition() || this.subSlides.get(((AbstractTemplateModel)this.getModel()).getStepPosition()) == null) {
            this.addSubSlide((Node)this.buildDefaultContent(((AbstractTemplateModel)this.getModel()).getContent(slideStep)));
        }
        Node nextSlide = this.subSlides.get(((AbstractTemplateModel)this.getModel()).getStepPosition());
        if (this.currentSubSlide == null || nextSlide == null) {
            this.currentSubSlide = nextSlide;
        } else {
            this.performStepAnimation(nextSlide);
        }
    }

    protected void showCustomSlideStep(Node node) {
        this.addSubSlide(node);
        Node nextSlide = this.subSlides.get(((AbstractTemplateModel)this.getModel()).getStepPosition());
        if (this.currentSubSlide == null || nextSlide == null) {
            this.currentSubSlide = nextSlide;
        } else {
            this.performStepAnimation(nextSlide);
        }
    }

    private void performStepAnimation(final Node nextSlide) {
        this.setSlideLocked(true);
        ParallelTransition subSlideTransition = ((ParallelTransitionBuilder)ParallelTransitionBuilder.create().onFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                AbstractTemplateView.this.currentSubSlide = nextSlide;
                AbstractTemplateView.this.setSlideLocked(false);
            }
        })).children(new Animation[]{SequentialTransitionBuilder.create().node(this.currentSubSlide).children(new Animation[]{TranslateTransitionBuilder.create().duration(Duration.millis((double)400.0)).fromY(0.0).toY(-700.0).build(), TimelineBuilder.create().keyFrames(new KeyFrame[]{new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.currentSubSlide.visibleProperty(), (Object)true)}), new KeyFrame(Duration.millis((double)1.0), new KeyValue[]{new KeyValue((WritableValue)this.currentSubSlide.visibleProperty(), (Object)false)})}).build()}).build(), SequentialTransitionBuilder.create().node(nextSlide).children(new Animation[]{TimelineBuilder.create().keyFrames(new KeyFrame[]{new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)nextSlide.visibleProperty(), (Object)false)}), new KeyFrame(Duration.millis((double)1.0), new KeyValue[]{new KeyValue((WritableValue)nextSlide.visibleProperty(), (Object)true)})}).build(), TranslateTransitionBuilder.create().duration(Duration.millis((double)400.0)).fromY(700.0).toY(0.0).build()}).build()}).build();
        subSlideTransition.play();
    }

    protected StackPane getSlideContent() {
        return this.slideContent;
    }
}

