/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.processor;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.jrebirth.af.modular.model.Component;
import org.jrebirth.af.modular.model.Module;
import org.jrebirth.af.modular.model.ObjectFactory;
import org.jrebirth.af.modular.model.Registration;
import org.jrebirth.af.modular.model.RegistrationEntry;
import org.jrebirth.af.processor.annotation.Register;
import org.jrebirth.af.processor.annotation.RegistrationPoint;
import org.jrebirth.af.processor.annotation.WarmUp;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class ComponentProcessor
extends AbstractProcessor {
    private static String MODULE_CONFIG_PATH = "JRAF-INF";
    private static String MODULE_CONFIG_FILE_NAME = "module.xml";
    private ObjectFactory factory;
    private JAXBContext jaxbContext;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.factory = new ObjectFactory();
        try {
            this.jaxbContext = JAXBContext.newInstance((String)"org.jrebirth.af.modular.model", (ClassLoader)ObjectFactory.class.getClassLoader());
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return new HashSet<String>(Arrays.asList(Register.class.getName(), RegistrationPoint.class.getName()));
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return false;
        }
        HashMap services = new HashMap();
        Elements elements = this.processingEnv.getElementUtils();
        Set<? extends Element> warmUps = roundEnv.getElementsAnnotatedWith(WarmUp.class);
        Set<? extends Element> registrationPoints = roundEnv.getElementsAnnotatedWith(RegistrationPoint.class);
        Set<? extends Element> registrations = roundEnv.getElementsAnnotatedWith(Register.class);
        Module module = null;
        if (module == null) {
            module = this.createModule();
        }
        for (Element element : warmUps) {
            WarmUp warmUp = element.getAnnotation(WarmUp.class);
            if (warmUp == null) continue;
            Component c = this.factory.createComponent();
            c.setClazz(this.getClassName(element));
            module.getWarmUp().getComponent().add(c);
        }
        for (Element element : registrationPoints) {
            RegistrationPoint registrationPoint = element.getAnnotation(RegistrationPoint.class);
            if (registrationPoint == null || !element.getKind().isInterface()) continue;
            Registration r = this.factory.createRegistration();
            r.setClazz(this.getClassName(element));
            r.setExclusive(Boolean.valueOf(registrationPoint.exclusive()));
            module.getRegistrations().getRegistration().add(r);
        }
        for (Element element : registrations) {
            Register registration = element.getAnnotation(Register.class);
            if (registration == null || element.getKind().isInterface() || !element.getKind().isClass()) continue;
            RegistrationEntry re = this.factory.createRegistrationEntry();
            re.setClazz(this.getClassName(element));
            re.setPriority(registration.priority().name());
            TypeMirror value = null;
            try {
                registration.value();
            }
            catch (MirroredTypeException mte) {
                value = mte.getTypeMirror();
            }
            String registeredClass = this.getClassName(value);
            for (Registration r : module.getRegistrations().getRegistration()) {
                if (registeredClass == null || !registeredClass.equals(r.getClazz())) continue;
                if (r.getRegistrationEntries() == null) {
                    r.setRegistrationEntries(this.factory.createRegistrationEntryList());
                }
                r.getRegistrationEntries().getRegistrationEntry().add(re);
            }
        }
        this.saveModule(module);
        return true;
    }

    private void saveModule(Module module) {
        try {
            FileObject fileObject = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", MODULE_CONFIG_PATH + "/" + MODULE_CONFIG_FILE_NAME, new Element[0]);
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)this.factory.createModule(module), fileObject.openOutputStream());
            marshaller.marshal((Object)this.factory.createModule(module), (OutputStream)System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Module createModule() {
        Module module = this.factory.createModule();
        module.setWarmUp(this.factory.createWarmUpList());
        module.setRegistrations(this.factory.createRegistrationList());
        return module;
    }

    private Module loadModuleFile() {
        Module module = null;
        File f = new File(MODULE_CONFIG_PATH + "/" + MODULE_CONFIG_FILE_NAME);
        if (f.exists()) {
            try {
                Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
                InputStreamReader in = new InputStreamReader(new FileInputStream(f));
                XMLStreamReader xsr = XMLInputFactory.newInstance().createXMLStreamReader(in);
                Object o = unmarshaller.unmarshal(xsr);
                module = (Module)Module.class.cast(((JAXBElement)JAXBElement.class.cast(o)).getValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return module;
    }

    private String getClassName(Element element) {
        return this.getClassName(element.asType());
    }

    private String getClassName(TypeMirror t) {
        String res = null;
        if (t instanceof DeclaredType) {
            DeclaredType dt = (DeclaredType)t;
            res = ((TypeElement)dt.asElement()).getQualifiedName().toString();
        }
        return res;
    }

    private void error(Element source, String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, source);
    }
}

