/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.processor;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.jrebirth.af.api.module.Register;
import org.jrebirth.af.api.module.RegistrationPoint;
import org.jrebirth.af.processor.annotation.bean.Bean;
import org.jrebirth.af.processor.util.FXBeanDefinition;
import org.jrebirth.af.processor.util.FXPropertyDefinition;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class BeanProcessor
extends AbstractProcessor {
    private static String MODULE_CONFIG_PATH = "JRAF-INF";
    private static String MODULE_CONFIG_FILE_NAME = "module.xml";

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return new HashSet<String>(Arrays.asList(Register.class.getName(), RegistrationPoint.class.getName()));
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ConcurrentHashMap fields = new ConcurrentHashMap();
        ConcurrentHashMap<String, ExecutableElement> methods = new ConcurrentHashMap<String, ExecutableElement>();
        for (Element element : roundEnv.getElementsAnnotatedWith(Bean.class)) {
            if (element.getKind() == ElementKind.CLASS) {
                FXBeanDefinition beanDef = new FXBeanDefinition();
                TypeElement classElement = (TypeElement)element;
                PackageElement packageElement = (PackageElement)classElement.getEnclosingElement();
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "annotated class: " + classElement.getQualifiedName(), element);
                beanDef.setClassName(classElement.getSimpleName().toString());
                beanDef.setPackageName(packageElement.getQualifiedName().toString());
                for (Element element2 : classElement.getEnclosedElements()) {
                    if (element2.getKind() != ElementKind.METHOD) continue;
                    ExecutableElement method = (ExecutableElement)element2;
                    FXPropertyDefinition propertyDef = new FXPropertyDefinition();
                    propertyDef.setType(method.getReturnType().toString());
                    propertyDef.setName(method.getSimpleName().toString());
                    beanDef.getProperties().add(propertyDef);
                }
            } else if (element.getKind() == ElementKind.METHOD) {
                ExecutableElement exeElement = (ExecutableElement)element;
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "annotated method: " + exeElement.getSimpleName(), element);
                methods.put(exeElement.getSimpleName().toString(), exeElement);
            }
            try {
                this.loadTemplate("fqClassName");
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return true;
    }

    private String getClassName(Element element) {
        return this.getClassName(element.asType());
    }

    private String getClassName(TypeMirror t) {
        String res = null;
        if (t instanceof DeclaredType) {
            DeclaredType dt = (DeclaredType)t;
            res = ((TypeElement)dt.asElement()).getQualifiedName().toString();
        }
        return res;
    }

    private void error(Element source, String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, source);
    }

    private void loadTemplate(String fqClassName) throws IOException {
        if (fqClassName != null) {
            Properties props = new Properties();
            URL url = this.getClass().getClassLoader().getResource("velocity.properties");
            try {
                props.load(url.openStream());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

