/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.jboss.forge.roaster.ParserException;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.compiler.IProblem;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTNode;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ImportDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Javadoc;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Modifier;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.PackageDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jface.text.Document;
import org.jboss.forge.roaster._shade.org.eclipse.text.edits.TextEdit;
import org.jboss.forge.roaster.model.Annotation;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.SyntaxError;
import org.jboss.forge.roaster.model.Type;
import org.jboss.forge.roaster.model.Visibility;
import org.jboss.forge.roaster.model.ast.AnnotationAccessor;
import org.jboss.forge.roaster.model.ast.ModifierAccessor;
import org.jboss.forge.roaster.model.impl.ImportImpl;
import org.jboss.forge.roaster.model.impl.JavaDocImpl;
import org.jboss.forge.roaster.model.impl.SyntaxErrorImpl;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.AnnotationTargetSource;
import org.jboss.forge.roaster.model.source.Import;
import org.jboss.forge.roaster.model.source.JavaDocSource;
import org.jboss.forge.roaster.model.source.JavaPackageInfoSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.util.Formatter;
import org.jboss.forge.roaster.model.util.Strings;
import org.jboss.forge.roaster.model.util.Types;
import org.jboss.forge.roaster.spi.WildcardImportResolver;

public class JavaPackageInfoImpl
implements JavaPackageInfoSource {
    protected final Document document;
    protected final CompilationUnit unit;
    protected final PackageDeclaration pkg;
    protected final JavaSource<?> enclosingType;
    private final AnnotationAccessor<JavaPackageInfoSource, JavaPackageInfoSource> annotations = new AnnotationAccessor();
    private final ModifierAccessor modifiers = new ModifierAccessor();
    private static List<WildcardImportResolver> resolvers;

    public JavaPackageInfoImpl(JavaSource<?> enclosingType, Document document, CompilationUnit unit, PackageDeclaration pkg) {
        this.enclosingType = enclosingType == null ? this : enclosingType;
        this.document = document;
        this.unit = unit;
        this.pkg = pkg;
    }

    @Override
    public String getName() {
        return "package-info";
    }

    @Override
    public JavaSource<?> getEnclosingType() {
        return this.enclosingType;
    }

    @Override
    public AnnotationSource<JavaPackageInfoSource> addAnnotation() {
        return this.annotations.addAnnotation((AnnotationTargetSource<JavaPackageInfoSource, JavaPackageInfoSource>)this, this.getPackageDeclaration());
    }

    @Override
    public AnnotationSource<JavaPackageInfoSource> addAnnotation(Class<? extends java.lang.annotation.Annotation> clazz) {
        return this.annotations.addAnnotation((AnnotationTargetSource<JavaPackageInfoSource, JavaPackageInfoSource>)this, (ASTNode)this.getPackageDeclaration(), clazz.getName());
    }

    @Override
    public AnnotationSource<JavaPackageInfoSource> addAnnotation(String className) {
        return this.annotations.addAnnotation((AnnotationTargetSource<JavaPackageInfoSource, JavaPackageInfoSource>)this, (ASTNode)this.getPackageDeclaration(), className);
    }

    @Override
    public List<AnnotationSource<JavaPackageInfoSource>> getAnnotations() {
        return this.annotations.getAnnotations((AnnotationTargetSource<JavaPackageInfoSource, JavaPackageInfoSource>)this, this.getPackageDeclaration());
    }

    @Override
    public boolean hasAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.hasAnnotation(this, this.getPackageDeclaration(), type.getName());
    }

    @Override
    public boolean hasAnnotation(String type) {
        return this.annotations.hasAnnotation(this, this.getPackageDeclaration(), type);
    }

    @Override
    public JavaPackageInfoSource removeAnnotation(Annotation<JavaPackageInfoSource> annotation) {
        return this.annotations.removeAnnotation(this, this.getPackageDeclaration(), annotation);
    }

    @Override
    public void removeAllAnnotations() {
        this.annotations.removeAllAnnotations(this.getPackageDeclaration());
    }

    @Override
    public AnnotationSource<JavaPackageInfoSource> getAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.getAnnotation((AnnotationTargetSource<JavaPackageInfoSource, JavaPackageInfoSource>)this, (ASTNode)this.getPackageDeclaration(), type);
    }

    @Override
    public AnnotationSource<JavaPackageInfoSource> getAnnotation(String type) {
        return this.annotations.getAnnotation((AnnotationTargetSource<JavaPackageInfoSource, JavaPackageInfoSource>)this, (ASTNode)this.getPackageDeclaration(), type);
    }

    @Override
    public Import addImport(Class<?> type) {
        return this.addImport(type.getCanonicalName());
    }

    @Override
    public <T extends JavaType<?>> Import addImport(T type) {
        String qualifiedName = type.getQualifiedName();
        return this.addImport(qualifiedName);
    }

    @Override
    public Import addImport(Import imprt) {
        return (Import)this.addImport(imprt.getQualifiedName()).setStatic(imprt.isStatic());
    }

    @Override
    public Import addImport(String className) {
        Import imprt;
        String strippedClassName = Types.stripGenerics(Types.stripArray(className));
        if (Types.isSimpleName(strippedClassName) && !this.hasImport(strippedClassName)) {
            throw new IllegalArgumentException("Cannot import class without a package [" + strippedClassName + "]");
        }
        if (!this.hasImport(strippedClassName) && this.validImport(strippedClassName)) {
            imprt = new ImportImpl(this).setName(strippedClassName);
            this.unit.imports().add(imprt.getInternal());
        } else if (this.hasImport(strippedClassName)) {
            imprt = this.getImport(strippedClassName);
        } else {
            throw new IllegalArgumentException("Attempted to import the illegal type [" + strippedClassName + "]");
        }
        return imprt;
    }

    @Override
    public Import getImport(String className) {
        List<Import> imports = this.getImports();
        for (Import imprt : imports) {
            if (!imprt.getQualifiedName().equals(className) && !imprt.getSimpleName().equals(className)) continue;
            return imprt;
        }
        return null;
    }

    @Override
    public Import getImport(Class<?> type) {
        return this.getImport(type.getName());
    }

    @Override
    public <T extends JavaType<?>> Import getImport(T type) {
        return this.getImport(type.getQualifiedName());
    }

    @Override
    public Import getImport(Import imprt) {
        return this.getImport(imprt.getQualifiedName());
    }

    @Override
    public List<Import> getImports() {
        ArrayList<ImportImpl> results = new ArrayList<ImportImpl>();
        for (ImportDeclaration i : this.unit.imports()) {
            results.add(new ImportImpl(this, i));
        }
        return Collections.unmodifiableList(results);
    }

    @Override
    public boolean hasImport(Class<?> type) {
        return this.hasImport(type.getName());
    }

    @Override
    public <T extends JavaType<T>> boolean hasImport(T type) {
        return this.hasImport(type.getQualifiedName());
    }

    @Override
    public boolean hasImport(Import imprt) {
        return this.hasImport(imprt.getQualifiedName());
    }

    @Override
    public boolean hasImport(String type) {
        String resultType = type;
        if (Types.isArray(type)) {
            resultType = Types.stripArray(type);
        }
        if (Types.isGeneric(type)) {
            resultType = Types.stripGenerics(type);
        }
        return this.getImport(resultType) != null;
    }

    @Override
    public boolean requiresImport(Class<?> type) {
        return this.requiresImport(type.getName());
    }

    @Override
    public boolean requiresImport(String type) {
        String resultType = type;
        if (Types.isArray(resultType)) {
            resultType = Types.stripArray(type);
        }
        if (Types.isGeneric(resultType)) {
            resultType = Types.stripGenerics(resultType);
        }
        return this.validImport(resultType) && !this.hasImport(resultType) && !Types.isJavaLang(resultType);
    }

    @Override
    public String resolveType(String type) {
        String original = type;
        String result = type;
        if (Types.isArray(result)) {
            original = Types.stripArray(result);
            result = Types.stripArray(result);
        }
        if (Types.isGeneric(result)) {
            original = Types.stripGenerics(result);
            result = Types.stripGenerics(result);
        }
        if (Types.isPrimitive(result)) {
            return result;
        }
        if (Types.isSimpleName(result)) {
            if (!this.hasImport(type) && Types.isJavaLang(type)) {
                result = "java.lang." + result;
            }
            if (result.equals(original)) {
                for (Import imprt : this.getImports()) {
                    if (!Types.areEquivalent(result, imprt.getQualifiedName())) continue;
                    result = imprt.getQualifiedName();
                    break;
                }
            }
        }
        if (Types.isSimpleName(result)) {
            for (Import imprt : this.getImports()) {
                WildcardImportResolver r;
                if (!imprt.isWildcard()) continue;
                Iterator<WildcardImportResolver> iterator = this.getImportResolvers().iterator();
                while (iterator.hasNext() && !Types.isQualified(result = (r = iterator.next()).resolve(this, result))) {
                }
            }
        }
        if (Types.isSimpleName(result) && this.getPackage() != null) {
            result = this.getPackage() + "." + result;
        }
        return result;
    }

    private List<WildcardImportResolver> getImportResolvers() {
        if (resolvers == null) {
            resolvers = new ArrayList<WildcardImportResolver>();
            for (WildcardImportResolver r : ServiceLoader.load(WildcardImportResolver.class, this.getClass().getClassLoader())) {
                resolvers.add(r);
            }
        }
        if (resolvers.size() == 0) {
            throw new IllegalStateException("No instances of [" + WildcardImportResolver.class.getName() + "] were found on the classpath.");
        }
        return resolvers;
    }

    private boolean validImport(String type) {
        return !Strings.isNullOrEmpty(type) && !Types.isPrimitive(type);
    }

    @Override
    public JavaPackageInfoSource removeImport(String name) {
        for (Import i : this.getImports()) {
            if (!i.getQualifiedName().equals(name)) continue;
            this.removeImport(i);
            break;
        }
        return this;
    }

    @Override
    public JavaPackageInfoSource removeImport(Class<?> clazz) {
        return this.removeImport(clazz.getName());
    }

    @Override
    public <T extends JavaType<?>> JavaPackageInfoSource removeImport(T type) {
        return this.removeImport(type.getQualifiedName());
    }

    @Override
    public JavaPackageInfoSource removeImport(Import imprt) {
        Object internal = imprt.getInternal();
        if (this.unit.imports().contains(internal)) {
            this.unit.imports().remove(internal);
        }
        return this;
    }

    protected PackageDeclaration getPackageDeclaration() {
        if (this.pkg instanceof PackageDeclaration) {
            return this.pkg;
        }
        throw new ParserException("Source body was not of the expected type (PackageDeclaration).");
    }

    @Override
    public JavaPackageInfoSource setName(String name) {
        throw new UnsupportedOperationException("Changing name of [" + this.getQualifiedName() + "] not supported.");
    }

    @Override
    public String getCanonicalName() {
        String result = this.getName();
        for (JavaType<JavaPackageInfoSource> enclosingTypeLocal = this; enclosingTypeLocal != enclosingTypeLocal.getEnclosingType(); enclosingTypeLocal = enclosingTypeLocal.getEnclosingType()) {
            enclosingTypeLocal = this.getEnclosingType();
            result = enclosingTypeLocal.getEnclosingType().getName() + "." + result;
        }
        if (!Strings.isNullOrEmpty(this.getPackage())) {
            result = this.getPackage() + "." + result;
        }
        return result;
    }

    @Override
    public String getQualifiedName() {
        String result = this.getName();
        for (JavaType<JavaPackageInfoSource> enclosingTypeLocal = this; enclosingTypeLocal != enclosingTypeLocal.getEnclosingType(); enclosingTypeLocal = enclosingTypeLocal.getEnclosingType()) {
            enclosingTypeLocal = this.getEnclosingType();
            result = enclosingTypeLocal.getEnclosingType().getName() + "$" + result;
        }
        if (!Strings.isNullOrEmpty(this.getPackage())) {
            result = this.getPackage() + "." + result;
        }
        return result;
    }

    @Override
    public String getPackage() {
        PackageDeclaration pkgLocal = this.unit.getPackage();
        if (pkgLocal != null) {
            return pkgLocal.getName().getFullyQualifiedName();
        }
        return null;
    }

    @Override
    public JavaPackageInfoSource setPackage(String name) {
        if (this.unit.getPackage() == null) {
            this.unit.setPackage(this.unit.getAST().newPackageDeclaration());
        }
        this.unit.getPackage().setName(this.unit.getAST().newName(name));
        return this;
    }

    @Override
    public JavaPackageInfoSource setDefaultPackage() {
        this.unit.setPackage(null);
        return this;
    }

    @Override
    public boolean isDefaultPackage() {
        return this.unit.getPackage() == null;
    }

    @Override
    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    @Override
    public JavaPackageInfoSource setPackagePrivate() {
        this.modifiers.clearVisibility(this.getPackageDeclaration());
        return this;
    }

    @Override
    public boolean isPublic() {
        return this.modifiers.hasModifier(this.getPackageDeclaration(), Modifier.ModifierKeyword.PUBLIC_KEYWORD);
    }

    @Override
    public JavaPackageInfoSource setPublic() {
        this.modifiers.clearVisibility(this.getPackageDeclaration());
        this.modifiers.addModifier(this.getPackageDeclaration(), Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        return this;
    }

    @Override
    public boolean isPrivate() {
        return this.modifiers.hasModifier(this.getPackageDeclaration(), Modifier.ModifierKeyword.PRIVATE_KEYWORD);
    }

    @Override
    public JavaPackageInfoSource setPrivate() {
        this.modifiers.clearVisibility(this.getPackageDeclaration());
        this.modifiers.addModifier(this.getPackageDeclaration(), Modifier.ModifierKeyword.PRIVATE_KEYWORD);
        return this;
    }

    @Override
    public boolean isProtected() {
        return this.modifiers.hasModifier(this.getPackageDeclaration(), Modifier.ModifierKeyword.PROTECTED_KEYWORD);
    }

    @Override
    public JavaPackageInfoSource setProtected() {
        this.modifiers.clearVisibility(this.getPackageDeclaration());
        this.modifiers.addModifier(this.getPackageDeclaration(), Modifier.ModifierKeyword.PROTECTED_KEYWORD);
        return this;
    }

    @Override
    public Visibility getVisibility() {
        return Visibility.getFrom(this);
    }

    @Override
    public JavaPackageInfoSource setVisibility(Visibility scope) {
        return Visibility.set(this, scope);
    }

    public String toString() {
        return Formatter.format(this.toUnformattedString());
    }

    @Override
    public String toUnformattedString() {
        Document documentLocal = new Document(this.document.get());
        try {
            TextEdit edit = this.unit.rewrite(documentLocal, null);
            edit.apply(documentLocal);
        }
        catch (Exception e) {
            throw new ParserException("Could not modify source: " + this.unit.toString(), e);
        }
        return documentLocal.get();
    }

    @Override
    public Object getInternal() {
        return this.unit;
    }

    @Override
    public JavaPackageInfoSource getOrigin() {
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pkg == null ? 0 : this.pkg.hashCode());
        result = 31 * result + (this.document == null ? 0 : this.document.hashCode());
        result = 31 * result + (this.enclosingType == null ? 0 : this.enclosingType.hashCode());
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaPackageInfoImpl other = (JavaPackageInfoImpl)obj;
        if (this.pkg == null ? other.pkg != null : !this.pkg.equals(other.pkg)) {
            return false;
        }
        if (this.document == null ? other.document != null : !this.document.equals(other.document)) {
            return false;
        }
        if (this.enclosingType == null ? other.enclosingType != null : !this.enclosingType.equals(other.enclosingType)) {
            return false;
        }
        return !(this.unit == null ? other.unit != null : !this.unit.equals(other.unit));
    }

    @Override
    public List<SyntaxError> getSyntaxErrors() {
        ArrayList<SyntaxError> result = new ArrayList<SyntaxError>();
        IProblem[] problems = this.unit.getProblems();
        if (problems != null) {
            for (IProblem problem : problems) {
                result.add(new SyntaxErrorImpl(this, problem));
            }
        }
        return result;
    }

    @Override
    public boolean hasSyntaxErrors() {
        return !this.getSyntaxErrors().isEmpty();
    }

    @Override
    public boolean isClass() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isAnnotation() {
        return false;
    }

    @Override
    public Import addImport(Type<?> type) {
        return this.addImport(type.getQualifiedName());
    }

    @Override
    public JavaDocSource<JavaPackageInfoSource> getJavaDoc() {
        Javadoc javadoc = this.pkg.getJavadoc();
        if (javadoc == null) {
            javadoc = this.pkg.getAST().newJavadoc();
            this.pkg.setJavadoc(javadoc);
        }
        return new JavaDocImpl<JavaPackageInfoSource>(this, javadoc);
    }

    @Override
    public JavaPackageInfoSource removeJavaDoc() {
        this.pkg.setJavadoc(null);
        return this;
    }

    @Override
    public boolean hasJavaDoc() {
        return this.pkg.getJavadoc() != null;
    }

    public CompilationUnit getUnit() {
        return this.unit;
    }

    public PackageDeclaration getPkg() {
        return this.pkg;
    }
}

