/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.JavaCore;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.ToolFactory;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.formatter.CodeFormatter;
import org.jboss.forge.roaster._shade.org.eclipse.jface.text.BadLocationException;
import org.jboss.forge.roaster._shade.org.eclipse.jface.text.Document;
import org.jboss.forge.roaster._shade.org.eclipse.text.edits.TextEdit;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.spi.Streams;

public abstract class Formatter {
    public static void format(File source) throws IOException {
        Formatter.format(null, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void format(File prefs, File source) throws IOException {
        Properties options = Formatter.readConfig(prefs);
        if (options == null) {
            options = Formatter.readConfigInternal();
        }
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(source));
            String content = Streams.toString(in);
            String formatted = Formatter.format(options, content);
            out = new BufferedOutputStream(new FileOutputStream(source));
            Streams.write(new ByteArrayInputStream(formatted.getBytes()), out);
        }
        catch (Throwable throwable) {
            Streams.closeQuietly(in);
            Streams.closeQuietly(out);
            throw throwable;
        }
        Streams.closeQuietly(in);
        Streams.closeQuietly(out);
    }

    public static String format(JavaClassSource javaClass) {
        return Formatter.format(javaClass.toString());
    }

    public static String format(Properties prefs, JavaClassSource javaClass) {
        return Formatter.format(prefs, javaClass.toString());
    }

    public static String format(String source) {
        Properties options = Formatter.readConfigInternal();
        return Formatter.format(options, source);
    }

    public static String format(Properties prefs, String source) {
        CodeFormatter codeFormatter = ToolFactory.createCodeFormatter(prefs);
        Document doc = new Document(source);
        try {
            TextEdit edit = codeFormatter.format(4104, source, 0, source.length(), 0, null);
            if (edit == null) {
                return source;
            }
            edit.apply(doc);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        return Formatter.ensureCorrectNewLines(doc.get());
    }

    private static Properties readConfig(File prefs) throws IOException {
        if (prefs != null) {
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(prefs));
            try {
                Properties config = Formatter.parseConfig(stream);
                Properties properties = Formatter.applyShadedPackageName(config);
                return properties;
            }
            catch (IOException e) {
                throw new IOException("Error reading preferences file: [" + prefs.getAbsolutePath() + "]", e);
            }
            finally {
                Streams.closeQuietly(stream);
            }
        }
        return null;
    }

    public static Properties applyShadedPackageName(Properties config) {
        Properties modified = new Properties();
        String shadePackage = JavaCore.class.getPackage().getName().replaceAll("org\\.eclipse.*$", "");
        for (Map.Entry<Object, Object> property : config.entrySet()) {
            modified.put(shadePackage + property.getKey(), property.getValue());
        }
        return modified;
    }

    private static Properties readConfigInternal() {
        Properties properties = new Properties();
        properties.setProperty("org.jboss.forge.roaster._shade.org.eclipse.jdt.core.compiler.source", "1.8");
        properties.setProperty("org.jboss.forge.roaster._shade.org.eclipse.jdt.core.compiler.compliance", "1.8");
        properties.setProperty("org.jboss.forge.roaster._shade.org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.8");
        properties.setProperty("org.jboss.forge.roaster._shade.org.eclipse.jdt.core.formatter.blank_lines_after_imports", "1");
        return properties;
    }

    private static Properties parseConfig(InputStream stream) throws IOException {
        try {
            Properties formatterOptions = new Properties();
            formatterOptions.load(stream);
            Properties properties = formatterOptions;
            return properties;
        }
        finally {
            Streams.closeQuietly(stream);
        }
    }

    private static String ensureCorrectNewLines(String content) {
        String newLine = System.getProperty("line.separator");
        if (content.indexOf("\n") != -1 && content.indexOf(newLine) == -1) {
            return content.replaceAll("\n", newLine);
        }
        return content;
    }
}

