/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.command;

import org.jrebirth.af.api.annotation.PriorityLevel;
import org.jrebirth.af.api.command.Command;
import org.jrebirth.af.api.command.CommandBean;
import org.jrebirth.af.api.concurrent.RunInto;
import org.jrebirth.af.api.concurrent.RunType;
import org.jrebirth.af.api.concurrent.SyncRun;
import org.jrebirth.af.api.facade.JRebirthEventType;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.WaveBean;
import org.jrebirth.af.api.wave.contract.WaveData;
import org.jrebirth.af.core.command.CommandRunnable;
import org.jrebirth.af.core.component.behavior.AbstractBehavioredComponent;
import org.jrebirth.af.core.concurrent.JRebirth;
import org.jrebirth.af.core.exception.CommandException;
import org.jrebirth.af.core.util.ClassUtility;
import org.jrebirth.af.core.wave.DefaultWaveBean;
import org.jrebirth.af.core.wave.JRebirthWaves;
import org.jrebirth.af.core.wave.WBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseCommand<WB extends WaveBean>
extends AbstractBehavioredComponent<Command>
implements CommandBean<WB> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBaseCommand.class);
    protected RunType runIntoThread;
    protected boolean syncRun;
    protected PriorityLevel runnablePriority;
    private Class<WB> waveBeanClass;

    public AbstractBaseCommand() {
        this(null, null);
    }

    public AbstractBaseCommand(RunType runType, PriorityLevel priority) {
        RunInto ria = ClassUtility.getLastClassAnnotation(this.getClass(), RunInto.class);
        this.runIntoThread = ria == null ? (runType == null ? RunType.JIT : runType) : ria.value();
        SyncRun sra = ClassUtility.getLastClassAnnotation(this.getClass(), SyncRun.class);
        boolean bl = this.syncRun = sra == null ? false : sra.value();
        this.runnablePriority = ria == null ? (priority == null ? PriorityLevel.Normal : priority) : ria.priority();
        this.waveBeanClass = ClassUtility.getGenericClassAssigned(this.getClass(), WaveBean.class);
        if (this.waveBeanClass == null) {
            this.waveBeanClass = DefaultWaveBean.class;
        }
    }

    protected abstract void perform(Wave var1) throws CommandException;

    @Override
    protected void processWave(Wave wave) {
        LOGGER.warn(this.getClass() + " should manage custom code to handle the wave " + wave.toString() + " or unlisten this type");
    }

    @Override
    public final Wave run() {
        return this.run(null);
    }

    @Override
    public final Wave run(Wave wave) {
        WaveData<Boolean> syncData;
        Wave commandWave = wave == null ? WBuilder.callCommand(this.getClass()) : wave;
        CommandRunnable commandRunnable = new CommandRunnable(this.getClass().getSimpleName(), this, commandWave);
        WaveData<Boolean> waveData = syncData = wave != null ? wave.getData(JRebirthWaves.FORCE_SYNC_COMMAND) : null;
        if (syncData == null && this.isSyncRun() || syncData != null && syncData.value().booleanValue()) {
            JRebirth.runSync(this.getRunInto(), commandRunnable, 5000L);
        } else {
            JRebirth.run(this.getRunInto(), commandRunnable, new long[0]);
        }
        return commandWave;
    }

    final void innerRun(Wave wave) throws CommandException {
        this.beforePerform(wave);
        this.perform(wave);
        this.afterPerform(wave);
    }

    protected abstract void beforePerform(Wave var1);

    protected abstract void afterPerform(Wave var1);

    protected final RunType getRunInto() {
        return this.runIntoThread;
    }

    protected final boolean isSyncRun() {
        return this.syncRun;
    }

    protected final PriorityLevel getPriorityLevel() {
        return this.runnablePriority;
    }

    protected void finalize() throws Throwable {
        this.localFacade().globalFacade().trackEvent(JRebirthEventType.DESTROY_COMMAND, null, this.getClass(), new String[0]);
        super.finalize();
    }

    @Override
    public WB waveBean(Wave wave) {
        return wave.waveBean(this.waveBeanClass);
    }

    protected void fireConsumed(Wave wave) {
        LOGGER.trace(this.getClass().getSimpleName() + " consumes  " + wave.toString());
        wave.status(Wave.Status.Consumed);
    }

    protected void fireHandled(Wave wave) {
        LOGGER.trace(this.getClass().getSimpleName() + " handles  " + wave.toString());
        wave.status(Wave.Status.Handled);
    }

    protected void fireFailed(Wave wave) {
        LOGGER.trace(this.getClass().getSimpleName() + " has failed  " + wave.toString());
        wave.status(Wave.Status.Failed);
    }
}

