/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.command;

import org.jrebirth.af.api.exception.JRebirthThreadException;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.WaveBean;
import org.jrebirth.af.core.command.AbstractBaseCommand;
import org.jrebirth.af.core.command.CommandMessages;
import org.jrebirth.af.core.concurrent.AbstractJrbRunnable;
import org.jrebirth.af.core.exception.CommandException;
import org.jrebirth.af.core.log.JRLoggerFactory;

final class CommandRunnable
extends AbstractJrbRunnable
implements CommandMessages {
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(CommandRunnable.class);
    private final Wave wave;
    private final AbstractBaseCommand<? extends WaveBean> command;

    CommandRunnable(String runnableName, AbstractBaseCommand<? extends WaveBean> command, Wave wave) {
        super(runnableName, command.getPriorityLevel());
        this.command = command;
        this.wave = wave;
    }

    @Override
    protected void runInto() throws JRebirthThreadException {
        try {
            this.command.innerRun(this.wave);
        }
        catch (CommandException ce) {
            LOGGER.error(CMD_EXCEPTION, ce);
            this.wave.status(Wave.Status.Failed);
        }
        catch (RuntimeException re) {
            LOGGER.error(UNPLANNED_FAILURE, re);
            this.wave.status(Wave.Status.Failed);
        }
    }
}

