/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.command.basic;

import java.util.List;
import org.jrebirth.af.api.exception.CoreRuntimeException;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.WaveListener;
import org.jrebirth.af.core.command.single.internal.DefaultCommand;
import org.jrebirth.af.core.resource.provided.parameter.CoreParameters;
import org.jrebirth.af.core.wave.JRebirthWaves;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainWaveCommand
extends DefaultCommand
implements WaveListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChainWaveCommand.class);
    private int index;
    private List<Wave> waveList;
    private Wave sourceWave;

    @Override
    protected void perform(Wave wave) {
        if (this.index == 0) {
            this.waveList = wave.get(JRebirthWaves.CHAINED_WAVES);
            this.sourceWave = wave;
        }
        this.unqueueWaves();
    }

    @Override
    public void afterPerform(Wave wave) {
    }

    private void unqueueWaves() {
        Wave waveToRun = this.waveList.get(this.index);
        if (waveToRun == null) {
            if (CoreParameters.DEVELOPER_MODE.get().booleanValue()) {
                throw new CoreRuntimeException("ChainWaveCommand shouldn't be called with null wave");
            }
            ++this.index;
            if (this.waveList.size() > this.index) {
                this.unqueueWaves();
            } else {
                this.fireHandled(this.sourceWave);
            }
        } else {
            LOGGER.trace("Unqueue wave N\u00b0 " + this.index + " >> " + waveToRun.toString());
            waveToRun.addWaveListener(this);
            this.sendWave(waveToRun);
        }
    }

    @Override
    public void waveCreated(Wave wave) {
    }

    @Override
    public void waveSent(Wave wave) {
    }

    @Override
    public void waveProcessed(Wave wave) {
    }

    @Override
    public void waveConsumed(Wave wave) {
    }

    @Override
    public void waveHandled(Wave wave) {
        ++this.index;
        if (this.waveList.size() > this.index) {
            this.unqueueWaves();
        } else {
            this.fireHandled(this.sourceWave);
        }
    }

    @Override
    public void waveFailed(Wave wave) {
        this.fireFailed(this.sourceWave);
    }

    @Override
    public void waveCancelled(Wave wave) {
    }

    @Override
    public void waveDestroyed(Wave wave) {
    }
}

