/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.command.basic.showmodel;

import javafx.scene.Node;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.core.command.basic.showmodel.DisplayModelWaveBean;
import org.jrebirth.af.core.command.single.ui.DefaultUIBeanCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetachModelCommand
extends DefaultUIBeanCommand<DisplayModelWaveBean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DetachModelCommand.class);

    @Override
    protected void perform(Wave wave) {
        Model hideModel = this.waveBean(wave).hideModel();
        if (hideModel == null && this.waveBean(wave).hideModelKey() != null) {
            hideModel = this.localFacade().globalFacade().uiFacade().retrieve(this.waveBean(wave).hideModelKey());
        }
        Node hideNode = null;
        if (hideModel == null) {
            LOGGER.warn("Impossible to detach a model because hideModel is null");
        } else {
            hideModel.doHideView(wave);
            hideNode = hideModel.node();
            if (hideNode == null) {
                LOGGER.warn("Impossible to dettach model {} because the node is null", (Object)hideModel.getClass().getSimpleName());
            } else if (this.waveBean(wave).uniquePlaceHolder() != null) {
                this.waveBean(wave).uniquePlaceHolder().set(null);
            } else if (this.waveBean(wave).childrenPlaceHolder() != null) {
                this.waveBean(wave).childrenPlaceHolder().remove((Object)hideNode);
            } else {
                LOGGER.warn("Impossible to detach model {}, no place holder found", (Object)hideModel.getClass().getSimpleName());
            }
        }
    }

    @Override
    public DisplayModelWaveBean waveBean(Wave wave) {
        return wave.waveBean(DisplayModelWaveBean.class);
    }
}

