/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.command.basic.showmodel;

import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.PauseTransition;
import javafx.animation.SequentialTransition;
import javafx.scene.Node;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.core.command.basic.showmodel.DisplayModelWaveBean;
import org.jrebirth.af.core.command.basic.showmodel.FadeInOutWaveBean;
import org.jrebirth.af.core.command.single.ui.DefaultUIBeanCommand;
import org.jrebirth.af.core.exception.CommandException;

public class FadeInOutCommand
extends DefaultUIBeanCommand<FadeInOutWaveBean> {
    @Override
    protected void initCommand() {
        super.initCommand();
    }

    @Override
    protected void perform(Wave wave) throws CommandException {
        Node node = this.getNode(wave);
        FadeInOutWaveBean waveBean = (FadeInOutWaveBean)this.waveBean(wave);
        FadeTransition fadeIn = new FadeTransition();
        fadeIn.setAutoReverse(false);
        fadeIn.setCycleCount(1);
        fadeIn.setFromValue(0.0);
        fadeIn.setToValue(1.0);
        fadeIn.setDuration(waveBean.fadingInDuration());
        fadeIn.setNode(node);
        PauseTransition pause = new PauseTransition();
        pause.setDuration(waveBean.showDuration());
        FadeTransition fadeOut = new FadeTransition();
        fadeOut.setAutoReverse(false);
        fadeOut.setCycleCount(1);
        fadeOut.setFromValue(1.0);
        fadeOut.setToValue(0.0);
        fadeOut.setDuration(waveBean.fadingOutDuration());
        fadeOut.setNode(node);
        SequentialTransition pt = new SequentialTransition();
        pt.getChildren().addAll((Object[])new Animation[]{fadeIn, pause, fadeOut});
        pt.play();
    }

    private Node getNode(Wave wave) {
        Node node = ((FadeInOutWaveBean)this.waveBean(wave)).node();
        if (node == null && wave.hasWaveBean(DisplayModelWaveBean.class)) {
            node = wave.waveBean(DisplayModelWaveBean.class).showModel().node();
        }
        return node;
    }
}

