/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.command.basic.showmodel;

import javafx.animation.FadeTransition;
import javafx.animation.ParallelTransition;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.util.Duration;
import org.jrebirth.af.api.concurrent.RunInto;
import org.jrebirth.af.api.concurrent.RunType;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.core.command.basic.showmodel.DisplayModelWaveBean;
import org.jrebirth.af.core.command.single.AbstractSingleCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunInto(value=RunType.JAT)
public class FadeTransitionCommand
extends AbstractSingleCommand<DisplayModelWaveBean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FadeTransitionCommand.class);

    @Override
    protected void initCommand() {
    }

    @Override
    protected void perform(Wave wave) {
        Node newNode;
        Node oldNode;
        Node node = oldNode = ((DisplayModelWaveBean)this.waveBean(wave)).hideModel() == null ? null : ((DisplayModelWaveBean)this.waveBean(wave)).hideModel().node();
        if (oldNode == null) {
            ObservableList<Node> parentContainer = ((DisplayModelWaveBean)this.waveBean(wave)).childrenPlaceHolder();
            oldNode = parentContainer.size() > 1 ? (Node)parentContainer.get(((DisplayModelWaveBean)this.waveBean(wave)).childrenPlaceHolder().size() - 1) : null;
        }
        Node node2 = newNode = ((DisplayModelWaveBean)this.waveBean(wave)).showModel() == null ? null : ((DisplayModelWaveBean)this.waveBean(wave)).showModel().node();
        if (oldNode != null || newNode != null) {
            FadeTransition ft;
            ParallelTransition animation = new ParallelTransition();
            if (oldNode != null) {
                ft = new FadeTransition();
                ft.setDuration(Duration.millis((double)600.0));
                ft.setNode(oldNode);
                ft.setFromValue(1.0);
                ft.setToValue(0.0);
                animation.getChildren().add((Object)ft);
            }
            if (newNode != null) {
                ft = new FadeTransition();
                ft.setDuration(Duration.millis((double)600.0));
                ft.setNode(newNode);
                ft.setFromValue(0.0);
                ft.setToValue(1.0);
                animation.getChildren().add((Object)ft);
            }
            Node oldNodeLink = oldNode;
            animation.setOnFinished(event -> {
                if (oldNodeLink != null) {
                    ((DisplayModelWaveBean)this.waveBean(wave)).childrenPlaceHolder().remove((Object)oldNodeLink);
                    LOGGER.info("Remove " + oldNodeLink.toString() + " from stack container");
                }
                ((DisplayModelWaveBean)this.waveBean(wave)).showModel().doShowView(wave);
            });
            animation.playFromStart();
        }
    }

    @Override
    protected void initInnerComponents() {
    }
}

