/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.command.basic.showmodel;

import org.jrebirth.af.api.exception.CoreRuntimeException;
import org.jrebirth.af.api.key.UniqueKey;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.core.command.basic.showmodel.DisplayModelWaveBean;
import org.jrebirth.af.core.command.single.pool.DefaultPoolBeanCommand;
import org.jrebirth.af.core.key.Key;
import org.jrebirth.af.core.ui.object.ModelConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareModelCommand
extends DefaultPoolBeanCommand<DisplayModelWaveBean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrepareModelCommand.class);

    @Override
    protected void perform(Wave wave) {
        UniqueKey<? extends Model> showModelKey;
        DisplayModelWaveBean wb = this.waveBean(wave);
        ModelConfig<Model, ?> data = wb.showModelData();
        UniqueKey<? extends Model> uniqueKey = showModelKey = data != null ? Key.create(data.modelClass(), data) : wb.showModelKey();
        if (showModelKey == null) {
            LOGGER.error("ModelClass is null");
            throw new CoreRuntimeException("Illegal action : Model Class is null");
        }
        Model modelInstance = this.localFacade().globalFacade().uiFacade().retrieve(showModelKey);
        if (modelInstance == null) {
            LOGGER.error("Model " + showModelKey.classField().getSimpleName() + " couldn't be created");
            throw new CoreRuntimeException("Illegal action : Model Instance is null: " + showModelKey.classField().getName());
        }
        this.waveBean(wave).showModel(modelInstance);
    }

    @Override
    public DisplayModelWaveBean waveBean(Wave wave) {
        return wave.waveBean(DisplayModelWaveBean.class);
    }
}

