/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.command.basic.stage;

import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.core.command.basic.stage.StageWaveBean;
import org.jrebirth.af.core.command.single.ui.DefaultUIBeanCommand;
import org.jrebirth.af.core.service.basic.StageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StageCommand
extends DefaultUIBeanCommand<StageWaveBean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StageCommand.class);

    @Override
    protected void perform(Wave wave) {
        LOGGER.info("Trigger stage action " + (Object)((Object)this.waveBean(wave).action()));
        switch (this.waveBean(wave).action()) {
            case show: {
                this.returnData(StageService.class, StageService.DO_OPEN_STAGE, this.waveBean(wave));
                break;
            }
            case hide: {
                this.returnData(StageService.class, StageService.DO_CLOSE_STAGE, this.waveBean(wave));
                break;
            }
            case destroy: {
                this.returnData(StageService.class, StageService.DO_DESTROY_STAGE, this.waveBean(wave));
                break;
            }
            default: {
                LOGGER.error("Undefined StageAction");
            }
        }
    }

    @Override
    public StageWaveBean waveBean(Wave wave) {
        return wave.waveBean(StageWaveBean.class);
    }
}

