/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.component.basic;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jrebirth.af.api.annotation.AfterInit;
import org.jrebirth.af.api.annotation.BeforeInit;
import org.jrebirth.af.api.annotation.OnRelease;
import org.jrebirth.af.api.annotation.PriorityLevel;
import org.jrebirth.af.api.annotation.Releasable;
import org.jrebirth.af.api.annotation.SkipAnnotation;
import org.jrebirth.af.api.command.Command;
import org.jrebirth.af.api.command.CommandBean;
import org.jrebirth.af.api.component.basic.Component;
import org.jrebirth.af.api.component.basic.InnerComponent;
import org.jrebirth.af.api.component.behavior.Behavior;
import org.jrebirth.af.api.concurrent.RunType;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.exception.CoreRuntimeException;
import org.jrebirth.af.api.facade.JRebirthEventType;
import org.jrebirth.af.api.link.Notifier;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.api.service.Service;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.WaveBean;
import org.jrebirth.af.api.wave.WaveGroup;
import org.jrebirth.af.api.wave.checker.WaveChecker;
import org.jrebirth.af.api.wave.contract.WaveData;
import org.jrebirth.af.api.wave.contract.WaveType;
import org.jrebirth.af.core.concurrent.JRebirth;
import org.jrebirth.af.core.concurrent.SyncRunnable;
import org.jrebirth.af.core.link.AbstractReady;
import org.jrebirth.af.core.link.ComponentEnhancer;
import org.jrebirth.af.core.link.LinkMessages;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.util.CheckerUtility;
import org.jrebirth.af.core.util.ClassUtility;
import org.jrebirth.af.core.util.ObjectUtility;
import org.jrebirth.af.core.wave.JRebirthItems;
import org.jrebirth.af.core.wave.WBuilder;

@SkipAnnotation(value=false)
public abstract class AbstractComponent<C extends Component<C>>
extends AbstractReady<C>
implements Component<C>,
JRebirthItems,
LinkMessages {
    public static final String PROCESS_WAVE_METHOD_NAME = "processWave";
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(AbstractComponent.class);
    protected boolean processUncaughtWave = false;
    private Map<String, List<Method>> lifecycleMethod;
    protected Component<?> rootComponent;
    protected Map<InnerComponent<?>, Component<?>> innerComponentMap;

    private Notifier getNotifier() {
        return this.localFacade().globalFacade().notifier();
    }

    @Override
    public final void listen(WaveType ... waveTypes) {
        this.listen((WaveChecker)null, (Method)null, waveTypes);
    }

    @Override
    public final void listen(WaveChecker waveChecker, WaveType ... waveTypes) {
        this.listen(waveChecker, (Method)null, waveTypes);
    }

    private String getWaveTypesString(WaveType[] waveTypes) {
        StringBuilder sb = new StringBuilder();
        for (WaveType waveType : waveTypes) {
            sb.append(waveType.toString()).append(" ");
        }
        return sb.toString();
    }

    @Override
    public final void listen(WaveChecker waveChecker, Method method, WaveType ... waveTypes) {
        if (!this.processUncaughtWave) {
            CheckerUtility.checkWaveTypeContract(this.getClass(), waveTypes);
        }
        AbstractComponent waveReady = this;
        LOGGER.trace(LinkMessages.LISTEN_WAVE_TYPE, this.getWaveTypesString(waveTypes), waveReady.getClass().getSimpleName());
        JRebirth.runIntoJIT(LISTEN_WAVE_TYPE.getText(this.getWaveTypesString(waveTypes), waveReady.getClass().getSimpleName()), () -> this.getNotifier().listen(waveReady, waveChecker, method, waveTypes));
    }

    @Override
    public final void unlisten(WaveType ... waveTypes) {
        AbstractComponent waveReady = this;
        LOGGER.trace(LinkMessages.UNLISTEN_WAVE_TYPE, this.getWaveTypesString(waveTypes), waveReady.getClass().getSimpleName());
        JRebirth.runIntoJIT(UNLISTEN_WAVE_TYPE.getText(this.getWaveTypesString(waveTypes), waveReady.getClass().getSimpleName()), () -> this.getNotifier().unlisten(waveReady, waveTypes));
    }

    @Override
    public final void sendWave(Wave wave) {
        if (wave.fromClass() == null) {
            wave.fromClass(this.getClass());
        }
        this.sendWaveIntoJit(wave);
    }

    @Override
    public final <WB extends WaveBean> Wave sendWave(WaveType waveType, WB waveBean) {
        return this.sendWaveIntoJit(this.createWave(WaveGroup.UNDEFINED, waveType, (Class)null, waveBean, new WaveBean[0]));
    }

    @Override
    public final Wave sendWave(WaveType waveType, WaveData<?> ... waveData) {
        return this.sendWaveIntoJit(this.createWave(WaveGroup.UNDEFINED, waveType, null, waveData));
    }

    @Override
    public final Wave callCommand(Class<? extends CommandBean<? extends WaveBean>> commandClass, WaveBean waveBean, WaveBean ... waveBeans) {
        return this.sendWaveIntoJit(this.createWave(WaveGroup.CALL_COMMAND, null, commandClass, waveBean, waveBeans));
    }

    @Override
    public final Wave callCommand(Class<? extends Command> commandClass, WaveData<?> ... data) {
        return this.sendWaveIntoJit(this.createWave(WaveGroup.CALL_COMMAND, null, commandClass, data));
    }

    @Override
    public final <WB extends WaveBean> Wave returnData(Class<? extends Service> serviceClass, WaveType waveType, WB waveBean) {
        return this.sendWaveIntoJit(this.createWave(WaveGroup.RETURN_DATA, waveType, serviceClass, waveBean, new WaveBean[0]));
    }

    @Override
    public final Wave returnData(Class<? extends Service> serviceClass, WaveType waveType, WaveData<?> ... data) {
        return this.sendWaveIntoJit(this.createWave(WaveGroup.RETURN_DATA, waveType, serviceClass, data));
    }

    @Override
    public final <WB extends WaveBean> Wave attachUi(Class<? extends Model> modelClass, WB waveBean) {
        return this.sendWaveIntoJit(this.createWave(WaveGroup.ATTACH_UI, null, modelClass, waveBean, new WaveBean[0]));
    }

    @Override
    public final Wave attachUi(Class<? extends Model> modelClass, WaveData<?> ... data) {
        return this.sendWaveIntoJit(this.createWave(WaveGroup.ATTACH_UI, null, modelClass, data));
    }

    private Wave sendWaveIntoJit(Wave wave) {
        CheckerUtility.checkWave(wave);
        wave.status(Wave.Status.Sent);
        PriorityLevel priority = wave.contains(JRebirthItems.priority) ? wave.get(JRebirthItems.priority) : PriorityLevel.Normal;
        RunType runType = wave.contains(JRebirthItems.runSynchronously) && wave.get(JRebirthItems.runSynchronously) != false ? RunType.JIT_SYNC : RunType.JIT;
        Long timeout = wave.contains(JRebirthItems.syncTimeout) ? wave.get(JRebirthItems.syncTimeout) : SyncRunnable.DEFAULT_TIME_OUT;
        JRebirth.run(runType, SEND_WAVE.getText(wave.toString()), priority, () -> this.getNotifier().sendWave(wave), timeout);
        return wave;
    }

    private Wave createWave(WaveGroup waveGroup, WaveType waveType, Class<?> componentClass, WaveData<?> ... waveData) {
        Wave wave = WBuilder.wave().waveGroup(waveGroup).waveType(waveType).fromClass(this.getClass()).componentClass(componentClass).addDatas(waveData);
        this.localFacade().globalFacade().trackEvent(JRebirthEventType.CREATE_WAVE, this.getClass(), wave.getClass(), new String[0]);
        return wave;
    }

    private Wave createWave(WaveGroup waveGroup, WaveType waveType, Class<?> componentClass, WaveBean waveBean, WaveBean ... waveBeans) {
        ArrayList<WaveBean> waveBeanList = new ArrayList<WaveBean>();
        waveBeanList.add(waveBean);
        if (waveBeans.length > 0) {
            waveBeanList.addAll(Arrays.asList(waveBeans));
        }
        Wave wave = WBuilder.wave().waveGroup(waveGroup).waveType(waveType).fromClass(this.getClass()).componentClass(componentClass).waveBeanList(waveBeanList);
        this.localFacade().globalFacade().trackEvent(JRebirthEventType.CREATE_WAVE, this.getClass(), wave.getClass(), new String[0]);
        return wave;
    }

    protected abstract void processWave(Wave var1);

    private Component<?> getWaveReady() {
        return this;
    }

    private void callAnnotatedMethod(Class<? extends Annotation> annotationClass) {
        if (this.lifecycleMethod.get(annotationClass.getName()) != null) {
            for (Method method : this.lifecycleMethod.get(annotationClass.getName())) {
                try {
                    ClassUtility.callMethod(method, this, new Object[0]);
                }
                catch (CoreException e) {
                    LOGGER.error(CALL_ANNOTATED_METHOD_ERROR, e);
                }
            }
        }
    }

    protected abstract void ready() throws CoreException;

    @Override
    public void setup() throws CoreException {
        boolean canProcessAnnotation = ComponentEnhancer.canProcessAnnotation(this.getClass());
        if (canProcessAnnotation) {
            ComponentEnhancer.injectComponent(this);
            this.lifecycleMethod = ComponentEnhancer.defineLifecycleMethod(this);
            ComponentEnhancer.manageOnWaveAnnotation(this);
        }
        this.callAnnotatedMethod(BeforeInit.class);
        this.manageOptionalData();
        if (canProcessAnnotation) {
            ComponentEnhancer.injectInnerComponent(this);
        }
        this.initInternalInnerComponents();
        this.ready();
        this.callAnnotatedMethod(AfterInit.class);
    }

    protected abstract void manageOptionalData();

    @Override
    public boolean release() {
        boolean released = false;
        if (ObjectUtility.checkAllMethodReturnTrue(this, ClassUtility.getAnnotatedMethods(this.getClass(), Releasable.class))) {
            JRebirth.runIntoJIT("Release " + this.getClass().getCanonicalName(), this::internalRelease);
            released = true;
        }
        return released;
    }

    private void internalRelease() {
        this.callAnnotatedMethod(OnRelease.class);
        if (this.localFacade() != null) {
            this.localFacade().unregister(this.key());
        }
        if (this.getInnerComponentMap().isPresent()) {
            ArrayList toRemove = new ArrayList();
            for (Component<?> component : this.getInnerComponentMap().get().values()) {
                component.release();
                toRemove.add(component);
            }
            for (Component<Object> component : toRemove) {
                this.getInnerComponentMap().get().remove(component.key());
            }
        }
    }

    private <IC extends Component<?>> void addInnerComponent(InnerComponent<IC> innerComponent) {
        if (!this.getInnerComponentMap().isPresent()) {
            this.innerComponentMap = new IdentityHashMap(10);
        }
        if (!this.innerComponentMap.containsKey(innerComponent)) {
            Class<IC> innerComponentClass = innerComponent.key().classField();
            Component childComponent = null;
            if (Command.class.isAssignableFrom(innerComponentClass)) {
                childComponent = (Component)this.localFacade().globalFacade().commandFacade().retrieve(innerComponent.key());
            } else if (Service.class.isAssignableFrom(innerComponentClass)) {
                childComponent = (Component)this.localFacade().globalFacade().serviceFacade().retrieve(innerComponent.key());
            } else if (Model.class.isAssignableFrom(innerComponentClass)) {
                childComponent = (Component)this.localFacade().globalFacade().uiFacade().retrieve(innerComponent.key());
            } else if (Behavior.class.isAssignableFrom(innerComponentClass)) {
                throw new CoreRuntimeException("Behaviors can not be used as Inner EnhancedComponent");
            }
            if (childComponent == null) {
                throw new CoreRuntimeException("Impossible to create Inner EnhancedComponent");
            }
            this.innerComponentMap.put(innerComponent, childComponent);
            childComponent.rootComponent(this);
        }
    }

    @Override
    public final <IC extends Component<?>> IC findInnerComponent(InnerComponent<IC> innerComponent) {
        if (!this.getInnerComponentMap().isPresent() || !this.getInnerComponentMap().get().containsKey(innerComponent)) {
            this.addInnerComponent(innerComponent);
        }
        return (IC)this.getInnerComponentMap().get().get(innerComponent);
    }

    @Override
    public Component<?> rootComponent() {
        return this.rootComponent;
    }

    @Override
    public void rootComponent(Component<?> rootComponent) {
        this.rootComponent = rootComponent;
    }

    protected final void initInternalInnerComponents() {
        this.initInnerComponents();
    }

    protected abstract void initInnerComponents();

    protected Optional<Map<InnerComponent<?>, Component<?>>> getInnerComponentMap() {
        return Optional.ofNullable(this.innerComponentMap);
    }
}

