/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.component.basic;

import org.jrebirth.af.api.component.basic.Component;
import org.jrebirth.af.api.component.basic.InnerComponent;
import org.jrebirth.af.api.key.UniqueKey;
import org.jrebirth.af.core.key.Key;

public class InnerComponentBase<C extends Component<?>>
implements InnerComponent<C> {
    private int uid;
    private final UniqueKey<C> innerComponentKey;
    private Component<?> hostComponent;
    private C innerComponent;

    InnerComponentBase(Class<C> componentClass, Object ... keyPart) {
        this.innerComponentKey = Key.create(componentClass, keyPart);
    }

    InnerComponentBase(UniqueKey<C> innerComponentKey) {
        this.innerComponentKey = innerComponentKey;
    }

    @Override
    public UniqueKey<C> key() {
        return this.innerComponentKey;
    }

    public int getUid() {
        return this.uid;
    }

    public InnerComponent<C> setUid(int uid) {
        this.uid = uid;
        return this;
    }

    public boolean equals(Object innerModel) {
        return innerModel instanceof InnerComponentBase && this.getUid() == ((InnerComponentBase)innerModel).getUid();
    }

    public int hashCode() {
        return this.getUid();
    }

    @Override
    public Component<?> host() {
        return this.hostComponent;
    }

    public InnerComponent<C> host(Component<?> hostComponent) {
        this.hostComponent = hostComponent;
        return this;
    }

    @Override
    public C get() {
        if (this.innerComponent == null) {
            this.innerComponent = this.hostComponent.findInnerComponent(this);
        }
        return this.innerComponent;
    }
}

