/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.component.factory;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jrebirth.af.api.component.basic.Component;
import org.jrebirth.af.api.component.factory.ComponentFactory;
import org.jrebirth.af.api.component.factory.RegistrationItem;
import org.jrebirth.af.api.component.factory.RegistrationPointItem;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.exception.CoreRuntimeException;
import org.jrebirth.af.core.component.factory.RegistrationPointItemBase;
import org.jrebirth.af.core.facade.FacadeMessages;
import org.jrebirth.af.core.util.MultiMap;

public final class DefaultComponentFactory
implements ComponentFactory,
FacadeMessages {
    private final Map<Class<?>, RegistrationPointItem> definitions = new HashMap();
    private final MultiMap<Class<?>, RegistrationItem> implementations = new MultiMap();

    @Override
    public void define(RegistrationPointItem item) {
        this.definitions.put(item.interfaceClass(), item);
    }

    @Override
    public void register(RegistrationItem item) {
        if (!item.interfaceClass().isAssignableFrom(item.implClass())) {
            throw new CoreRuntimeException("");
        }
        this.definitions.put(item.interfaceClass(), ((RegistrationPointItemBase)RegistrationPointItemBase.create().interfaceClass((Class)item.interfaceClass())).exclusive(false).reverse(false));
        this.implementations.add(item.interfaceClass(), item);
    }

    @Override
    public <R> List<R> buildComponents(Class<R> clazz) throws CoreException {
        try {
            ArrayList<Component<Object>> components = new ArrayList<Component<Object>>();
            if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
                RegistrationPointItem definition = this.definitions.get(clazz);
                Object items = this.implementations.get(clazz);
                if (items != null) {
                    Collections.sort(items);
                    if (!definition.reverse()) {
                        Collections.reverse(items);
                    }
                    int nbComponent = definition.exclusive() ? 1 : Integer.MAX_VALUE;
                    for (RegistrationItem item : items.stream().limit(nbComponent).collect(Collectors.toList())) {
                        components.add(item.implClass().newInstance());
                    }
                }
            } else {
                components.add((Component<Object>)clazz.newInstance());
            }
            return components;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CoreException(COMPONENT_BUILD_ERROR.getText(clazz.getName()), (Throwable)e);
        }
    }
}

