/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.component.factory;

import org.jrebirth.af.api.annotation.PriorityLevel;
import org.jrebirth.af.api.component.basic.Component;
import org.jrebirth.af.api.component.factory.RegistrationItem;

public class RegistrationItemBase
implements RegistrationItem {
    private Class<? extends Component<?>> interfaceClass;
    private Class<? extends Component<?>> implClass;
    private PriorityLevel priority;
    private int weight;

    public static RegistrationItemBase create() {
        return new RegistrationItemBase();
    }

    @Override
    public Class<? extends Component<?>> interfaceClass() {
        return this.interfaceClass;
    }

    @Override
    public RegistrationItemBase interfaceClass(Class<? extends Component<?>> interfaceClass) {
        this.interfaceClass = interfaceClass;
        return this;
    }

    @Override
    public Class<? extends Component<?>> implClass() {
        return this.implClass;
    }

    @Override
    public RegistrationItemBase implClass(Class<? extends Component<?>> implClass) {
        this.implClass = implClass;
        return this;
    }

    @Override
    public PriorityLevel priority() {
        return this.priority;
    }

    @Override
    public RegistrationItemBase priority(PriorityLevel priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public int weight() {
        return this.weight;
    }

    @Override
    public RegistrationItemBase weight(int weight) {
        this.weight = weight % 1000;
        return this;
    }

    @Override
    public int compareTo(RegistrationItem o) {
        int priorityDiff = 0;
        if (this.priority() != null) {
            priorityDiff = o.priority() != null ? this.priority().level(this.weight()) - o.priority().level(o.weight()) : 1;
        } else if (o.priority() != null) {
            priorityDiff = -1;
        }
        return priorityDiff == 0 ? this.implClass().getName().compareTo(o.implClass().getName()) : priorityDiff;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.implClass == null ? 0 : this.implClass.getName().hashCode());
        result = 31 * result + (this.interfaceClass == null ? 0 : this.interfaceClass.getName().hashCode());
        result = 31 * result + (this.priority == null ? 0 : this.priority.hashCode());
        result = 31 * result + this.weight;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegistrationItemBase other = (RegistrationItemBase)obj;
        if (this.implClass == null ? other.implClass != null : !this.implClass.equals(other.implClass)) {
            return false;
        }
        if (this.interfaceClass == null ? other.interfaceClass != null : !this.interfaceClass.equals(other.interfaceClass)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        return this.weight == other.weight;
    }
}

