/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.concurrent;

import java.time.Instant;
import org.jrebirth.af.api.annotation.PriorityLevel;
import org.jrebirth.af.api.concurrent.JRebirthRunnable;
import org.jrebirth.af.api.exception.JRebirthThreadException;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.core.concurrent.ConcurrentMessages;
import org.jrebirth.af.core.log.JRLoggerFactory;

public abstract class AbstractJrbRunnable
implements JRebirthRunnable,
ConcurrentMessages {
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(AbstractJrbRunnable.class);
    private final String runnableName;
    private final PriorityLevel priority;
    private final Instant creationTime = Instant.now();

    public AbstractJrbRunnable(String runnableName) {
        this(runnableName, PriorityLevel.Normal);
    }

    public AbstractJrbRunnable(String runnableName, PriorityLevel priority) {
        this.runnableName = runnableName;
        this.priority = priority;
    }

    @Override
    public final void run() {
        LOGGER.trace(RUN_IT, this.runnableName());
        try {
            this.runInto();
        }
        catch (JRebirthThreadException jte) {
            LOGGER.error(THREAD_ERROR, jte, jte.getMessage());
        }
    }

    protected abstract void runInto() throws JRebirthThreadException;

    public String toString() {
        return "JRebirthRunnable - " + this.runnableName();
    }

    @Override
    public PriorityLevel priority() {
        return this.priority;
    }

    @Override
    public String runnableName() {
        return this.runnableName;
    }

    @Override
    public Instant creationTime() {
        return this.creationTime;
    }
}

