/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.concurrent;

import javafx.application.Platform;
import org.jrebirth.af.api.annotation.PriorityLevel;
import org.jrebirth.af.api.concurrent.JRebirthRunnable;
import org.jrebirth.af.api.concurrent.RunType;
import org.jrebirth.af.api.exception.JRebirthThreadException;
import org.jrebirth.af.core.concurrent.JRebirthThread;
import org.jrebirth.af.core.concurrent.JrbReferenceRunnable;
import org.jrebirth.af.core.concurrent.SyncRunnable;

public final class JRebirth {
    private JRebirth() {
    }

    public static void run(RunType runInto, String runnableName, Runnable runnable, long ... timeout) {
        JRebirth.run(runInto, new JrbReferenceRunnable(runnableName, runnable), timeout);
    }

    public static void run(RunType runInto, String runnableName, PriorityLevel runnablePriority, Runnable runnable, long ... timeout) {
        JRebirth.run(runInto, new JrbReferenceRunnable(runnableName, runnablePriority, runnable), timeout);
    }

    public static void run(RunType runInto, JRebirthRunnable runnable, long ... timeout) {
        switch (runInto) {
            case JAT: {
                JRebirth.runIntoJAT(runnable);
                break;
            }
            case JAT_SYNC: {
                JRebirth.runIntoJATSync(runnable, timeout);
                break;
            }
            case JIT: {
                JRebirth.runIntoJIT(runnable);
                break;
            }
            case JIT_SYNC: {
                JRebirth.runIntoJITSync(runnable, timeout);
                break;
            }
            case JTP: {
                JRebirth.runIntoJTP(runnable);
                break;
            }
            case JTP_SYNC: {
                JRebirth.runIntoJTPSync(runnable, timeout);
                break;
            }
            default: {
                runnable.run();
            }
        }
    }

    public static void runSync(RunType runInto, String runnableName, Runnable runnable, long ... timeout) {
        JRebirth.runSync(runInto, new JrbReferenceRunnable(runnableName, runnable), timeout);
    }

    public static void runSync(RunType runInto, String runnableName, PriorityLevel runnablePriority, Runnable runnable, long ... timeout) {
        JRebirth.runSync(runInto, new JrbReferenceRunnable(runnableName, runnablePriority, runnable), timeout);
    }

    public static void runSync(RunType runInto, JRebirthRunnable runnable, long ... timeout) {
        switch (runInto) {
            case JAT: 
            case JAT_SYNC: {
                JRebirth.runIntoJATSync(runnable, timeout);
                break;
            }
            case JIT: 
            case JIT_SYNC: {
                JRebirth.runIntoJITSync(runnable, timeout);
                break;
            }
            case JTP: 
            case JTP_SYNC: {
                JRebirth.runIntoJTPSync(runnable, timeout);
                break;
            }
            default: {
                runnable.run();
            }
        }
    }

    public static void runIntoJAT(String runnableName, Runnable runnable) {
        JRebirth.runIntoJAT(new JrbReferenceRunnable(runnableName, runnable));
    }

    public static void runIntoJAT(JRebirthRunnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }

    public static void runIntoJATSync(String runnableName, Runnable runnable, long ... timeout) {
        JRebirth.runIntoJATSync(new JrbReferenceRunnable(runnableName, runnable), timeout);
    }

    public static void runIntoJATSync(JRebirthRunnable runnable, long ... timeout) {
        SyncRunnable sync = new SyncRunnable(runnable);
        if (Platform.isFxApplicationThread()) {
            sync.run();
        } else {
            Platform.runLater((Runnable)sync);
            sync.waitEnd(timeout);
        }
    }

    public static void runIntoJIT(String runnableName, Runnable runnable) {
        JRebirth.runIntoJIT(new JrbReferenceRunnable(runnableName, runnable));
    }

    public static void runIntoJIT(String runnableName, PriorityLevel runnablePriority, Runnable runnable) {
        JRebirth.runIntoJIT(new JrbReferenceRunnable(runnableName, runnablePriority, runnable));
    }

    public static void runIntoJIT(JRebirthRunnable runnable) {
        JRebirthThread.getThread().runLater(runnable);
    }

    public static void runIntoJITSync(String runnableName, Runnable runnable, long ... timeout) {
        JRebirth.runIntoJITSync(new JrbReferenceRunnable(runnableName, runnable), timeout);
    }

    public static void runIntoJITSync(String runnableName, PriorityLevel runnablePriority, Runnable runnable, long ... timeout) {
        JRebirth.runIntoJITSync(new JrbReferenceRunnable(runnableName, runnablePriority, runnable), timeout);
    }

    public static void runIntoJITSync(JRebirthRunnable runnable, long ... timeout) {
        SyncRunnable sync = new SyncRunnable(runnable);
        if (JRebirth.isJIT()) {
            sync.run();
        } else {
            JRebirthThread.getThread().runLater(sync);
            sync.waitEnd(timeout);
        }
    }

    public static void runIntoJTP(String runnableName, Runnable runnable) {
        JRebirth.runIntoJTP(new JrbReferenceRunnable(runnableName, runnable));
    }

    public static void runIntoJTP(String runnableName, PriorityLevel runnablePriority, Runnable runnable) {
        JRebirth.runIntoJTP(new JrbReferenceRunnable(runnableName, runnablePriority, runnable));
    }

    public static void runIntoJTP(JRebirthRunnable runnable) {
        JRebirthThread.getThread().runIntoJTP(runnable);
    }

    public static void runIntoJTPSync(String runnableName, Runnable runnable, long ... timeout) {
        JRebirth.runIntoJTPSync(new JrbReferenceRunnable(runnableName, runnable), timeout);
    }

    public static void runIntoJTPSync(String runnableName, PriorityLevel runnablePriority, Runnable runnable, long ... timeout) {
        JRebirth.runIntoJTPSync(new JrbReferenceRunnable(runnableName, runnablePriority, runnable), timeout);
    }

    public static void runIntoJTPSync(JRebirthRunnable runnable, long ... timeout) {
        SyncRunnable sync = new SyncRunnable(runnable);
        if (JRebirth.isJTPSlot()) {
            sync.run();
        } else {
            JRebirthThread.getThread().runIntoJTP(sync);
            sync.waitEnd(timeout);
        }
    }

    public static boolean isJAT() {
        return Platform.isFxApplicationThread();
    }

    public static boolean isJIT() {
        return "JIT".equals(Thread.currentThread().getName());
    }

    public static boolean isJTPSlot() {
        return Thread.currentThread().getName().startsWith("JTP Slot ") || Thread.currentThread().getName().startsWith("HPTP Slot ");
    }

    public static void checkJAT() throws JRebirthThreadException {
        if (!Platform.isFxApplicationThread()) {
            throw new JRebirthThreadException(JRebirthThreadException.Type.NOT_RUN_INTO_JAT);
        }
    }

    public static void checkJIT() throws JRebirthThreadException {
        if (!JRebirth.isJIT()) {
            throw new JRebirthThreadException(JRebirthThreadException.Type.NOT_RUN_INTO_JIT);
        }
    }

    public static void checkJTPSlot() throws JRebirthThreadException {
        if (!JRebirth.isJTPSlot()) {
            throw new JRebirthThreadException(JRebirthThreadException.Type.NOT_RUN_INTO_JTP);
        }
    }
}

