/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Scene;
import org.jrebirth.af.api.application.JRebirthApplication;
import org.jrebirth.af.api.concurrent.JRebirthRunnable;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.exception.JRebirthThreadException;
import org.jrebirth.af.api.facade.GlobalFacade;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.core.command.basic.showmodel.DisplayModelWaveBean;
import org.jrebirth.af.core.command.basic.showmodel.ShowModelCommand;
import org.jrebirth.af.core.concurrent.ConcurrentMessages;
import org.jrebirth.af.core.concurrent.JRebirthRunnableComparator;
import org.jrebirth.af.core.facade.GlobalFacadeBase;
import org.jrebirth.af.core.key.Key;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.resource.provided.parameter.CoreParameters;
import org.jrebirth.af.core.service.basic.StyleSheetTrackerService;
import org.jrebirth.af.core.wave.WBuilder;

public final class JRebirthThread
extends Thread
implements ConcurrentMessages {
    public static final String JIT_NAME = "JIT";
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(JRebirthThread.class);
    private static JRebirthThread internalThread;
    private transient GlobalFacade facade;
    private transient JRebirthApplication<?> application;
    private final PriorityBlockingQueue<JRebirthRunnable> processingTasks;
    private final AtomicBoolean hasStarted = new AtomicBoolean(false);
    private final AtomicBoolean infiniteLoop = new AtomicBoolean(true);
    private final AtomicBoolean forceClose = new AtomicBoolean(false);

    private JRebirthThread() {
        super(JIT_NAME);
        this.setDaemon(true);
        this.processingTasks = new PriorityBlockingQueue<Runnable>(10, new JRebirthRunnableComparator());
    }

    public void runIntoJTP(JRebirthRunnable runnable) {
        if (this.getFacade().executorService().checkAvailability(runnable.priority())) {
            this.getFacade().executorService().execute(runnable);
            LOGGER.log(JTP_QUEUED, runnable.toString());
        } else {
            this.getFacade().highPriorityExecutorService().execute(runnable);
            LOGGER.log(HPTP_QUEUED, runnable.toString());
        }
    }

    public void runLater(JRebirthRunnable runnable) {
        this.processingTasks.add(runnable);
    }

    public void prepare(JRebirthApplication<?> application) {
        this.application = application;
        this.facade = new GlobalFacadeBase(application);
    }

    public boolean hasStarted() {
        return this.hasStarted.get();
    }

    @Override
    public void run() {
        this.manageStyleSheetReloading(this.application.scene());
        try {
            this.bootUp();
        }
        catch (JRebirthThreadException e) {
            LOGGER.error(BOOT_UP_ERROR, e);
        }
        this.hasStarted.set(true);
        while (this.infiniteLoop.get()) {
            try {
                JRebirthRunnable jrr;
                if (this.forceClose.get() || (jrr = this.processingTasks.poll(100L, TimeUnit.MILLISECONDS)) == null) continue;
                jrr.run();
            }
            catch (InterruptedException e) {
                LOGGER.error(JIT_ERROR, e);
            }
        }
        this.shutdown();
    }

    private void manageStyleSheetReloading(Scene scene) {
        if (CoreParameters.DEVELOPER_MODE.get().booleanValue() && scene != null) {
            for (String styleSheet : scene.getStylesheets()) {
                this.getFacade().serviceFacade().retrieve(StyleSheetTrackerService.class, new Object[0]).listen(styleSheet, this.application.scene());
            }
            this.getFacade().serviceFacade().retrieve(StyleSheetTrackerService.class, new Object[0]).start();
        }
    }

    public void bootUp() throws JRebirthThreadException {
        List<Wave> postBootList;
        Wave firstViewWave;
        ArrayList<Wave> chainedWaveList = new ArrayList<Wave>();
        List<Wave> preBootList = this.getApplication().preBootWaveList();
        if (preBootList != null && !preBootList.isEmpty()) {
            chainedWaveList.addAll(preBootList);
        }
        if ((firstViewWave = this.getLaunchFirstViewWave()) != null) {
            chainedWaveList.add(firstViewWave);
        }
        if ((postBootList = this.getApplication().postBootWaveList()) != null && !postBootList.isEmpty()) {
            chainedWaveList.addAll(postBootList);
        }
        if (!chainedWaveList.isEmpty()) {
            this.getFacade().notifier().sendWave(WBuilder.chainWaveCommand(chainedWaveList));
        }
    }

    @Override
    public void interrupt() {
        super.interrupt();
        this.shutdown();
    }

    public void close() {
        if (this.infiniteLoop.get()) {
            this.infiniteLoop.set(false);
        } else {
            this.forceClose.set(true);
            this.processingTasks.clear();
        }
    }

    private void shutdown() {
        try {
            this.facade.stop();
            this.facade = null;
            JRebirthThread.destroyInstance();
        }
        catch (CoreException e) {
            LOGGER.log(SHUTDOWN_ERROR, e);
        }
    }

    private static void destroyInstance() {
        internalThread = null;
    }

    protected Wave getLaunchFirstViewWave() {
        Wave firstWave = null;
        if (this.application != null && this.application.rootNode() != null && this.application.firstModelClass() != null) {
            firstWave = WBuilder.callCommand(ShowModelCommand.class).waveBean(DisplayModelWaveBean.create().childrenPlaceHolder((ObservableList<Node>)this.application.rootNode().getChildren()).showModelKey(Key.create(this.application.firstModelClass(), new Object[0])));
        }
        return firstWave;
    }

    public JRebirthApplication<?> getApplication() {
        return this.application;
    }

    public GlobalFacade getFacade() {
        return this.facade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JRebirthThread getThread() {
        Class<JRebirthThread> clazz = JRebirthThread.class;
        synchronized (JRebirthThread.class) {
            if (internalThread == null) {
                internalThread = new JRebirthThread();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return internalThread;
        }
    }
}

