/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jrebirth.af.api.annotation.PriorityLevel;
import org.jrebirth.af.api.concurrent.IJRebirthThreadPoolExecutor;
import org.jrebirth.af.api.concurrent.JRebirthRunnable;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.core.concurrent.ConcurrentMessages;
import org.jrebirth.af.core.concurrent.JRebirthRunnableComparator;
import org.jrebirth.af.core.log.JRLoggerFactory;

public class JRebirthThreadPoolExecutor
extends ThreadPoolExecutor
implements IJRebirthThreadPoolExecutor,
ConcurrentMessages {
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(JRebirthThreadPoolExecutor.class);
    private final List<JRebirthRunnable> pending = new ArrayList<JRebirthRunnable>();

    public JRebirthThreadPoolExecutor(int threadNumber, ThreadFactory threadFactory) {
        super(threadNumber, threadNumber, 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(threadNumber, new JRebirthRunnableComparator()), threadFactory);
    }

    @Override
    public boolean checkAvailability(PriorityLevel taskPriority) {
        return this.getActiveCount() < this.getCorePoolSize() || this.checkPriority(taskPriority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkPriority(PriorityLevel taskPriority) {
        boolean highPriority = false;
        List<JRebirthRunnable> list = this.pending;
        synchronized (list) {
            for (JRebirthRunnable jr : this.pending) {
                highPriority |= taskPriority.level() > jr.priority().level();
            }
        }
        return !highPriority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        List<JRebirthRunnable> list = this.pending;
        synchronized (list) {
            this.pending.add((JRebirthRunnable)r);
        }
        super.beforeExecute(t, r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        List<JRebirthRunnable> list = this.pending;
        synchronized (list) {
            this.pending.remove(r);
        }
        Throwable rootCause = null;
        if (t == null && r instanceof Future) {
            try {
                Object result = ((Future)((Object)r)).get();
                if (result != null) {
                    LOGGER.log(FUTURE_DONE, r.hashCode(), result.toString());
                }
            }
            catch (CancellationException | ExecutionException e) {
                rootCause = e.getCause();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        if (t != null) {
            LOGGER.log(JTP_ERROR, t);
        }
        if (rootCause != null) {
            LOGGER.log(JTP_ERROR_EXPLANATION, rootCause);
        }
    }
}

