/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.concurrent;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jrebirth.af.api.concurrent.JRebirthRunnable;

public class SyncRunnable
implements JRebirthRunnable {
    public static final Long DEFAULT_TIME_OUT = 1000L;
    public static final Long SLEEP_TIME = 100L;
    private final JRebirthRunnable innerRunnable;
    private final AtomicBoolean hasRun = new AtomicBoolean(false);

    public SyncRunnable(JRebirthRunnable innerRunnable) {
        this.innerRunnable = innerRunnable;
    }

    @Override
    public void run() {
        this.innerRunnable.run();
        this.hasRun.set(true);
    }

    public void waitEnd(long ... timeout) {
        long start = System.currentTimeMillis();
        start = timeout.length == 1 ? (start += timeout[0]) : (start += DEFAULT_TIME_OUT.longValue());
        while (!this.hasRun.get()) {
            try {
                Thread.sleep(SLEEP_TIME);
            }
            catch (InterruptedException e) {
                break;
            }
            if (System.currentTimeMillis() <= start) continue;
            break;
        }
    }
}

