/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.facade;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.jrebirth.af.api.command.Command;
import org.jrebirth.af.api.component.basic.Component;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.exception.CoreRuntimeException;
import org.jrebirth.af.api.exception.JRebirthThreadException;
import org.jrebirth.af.api.facade.FacadeReady;
import org.jrebirth.af.api.facade.GlobalFacade;
import org.jrebirth.af.api.facade.JRebirthEventType;
import org.jrebirth.af.api.facade.LocalFacade;
import org.jrebirth.af.api.key.UniqueKey;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.api.service.Service;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.core.facade.AbstractGlobalReady;
import org.jrebirth.af.core.facade.FacadeMessages;
import org.jrebirth.af.core.key.ClassKey;
import org.jrebirth.af.core.key.Key;
import org.jrebirth.af.core.key.MultitonKey;
import org.jrebirth.af.core.log.JRLoggerFactory;

public abstract class AbstractFacade<R extends FacadeReady<R>>
extends AbstractGlobalReady
implements LocalFacade<R>,
FacadeMessages {
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(AbstractFacade.class);
    private final Map<UniqueKey<? extends R>, Set<R>> componentMap = Collections.synchronizedMap(new WeakHashMap());

    public AbstractFacade(GlobalFacade globalFacade) {
        super(globalFacade);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends R> void register(UniqueKey<E> registrationKey, E readyObject) {
        Map<UniqueKey<? extends R>, Set<R>> map = this.componentMap;
        synchronized (map) {
            if (readyObject.key() == null) {
                readyObject.key(registrationKey);
            }
            readyObject.localFacade(this);
            if (!this.componentMap.containsKey(registrationKey)) {
                Set weakHashSet = Collections.newSetFromMap(new WeakHashMap());
                this.componentMap.put(registrationKey, weakHashSet);
            }
            this.componentMap.get(registrationKey).add(readyObject);
        }
    }

    @Override
    public <E extends R> void register(E readyObject, Object ... keyPart) {
        this.register(Key.create(readyObject.getClass(), keyPart), readyObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends R> void unregister(UniqueKey<E> uniqueKey) {
        Map<UniqueKey<? extends R>, Set<R>> map = this.componentMap;
        synchronized (map) {
            List<E> readyObjectList = this.getReadyObjectList(uniqueKey);
            for (FacadeReady readyObject : readyObjectList) {
                if (readyObject instanceof Component) {
                    try {
                        this.globalFacade().notifier().unlistenAll((Component)readyObject);
                    }
                    catch (JRebirthThreadException e) {
                        LOGGER.error(UNLISTEN_ALL_ERROR, readyObject.getClass().getSimpleName(), e);
                    }
                }
                readyObject.key(null);
                readyObject.localFacade(null);
            }
            this.componentMap.remove(uniqueKey);
        }
    }

    @Override
    public <E extends R> void unregister(E readyObject, Object ... keyPart) {
        this.unregister(Key.create(readyObject.getClass(), keyPart));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends R> boolean exists(UniqueKey<E> uniqueKey) {
        boolean res;
        Map<UniqueKey<? extends R>, Set<R>> map = this.componentMap;
        synchronized (map) {
            res = this.componentMap.containsKey(uniqueKey) && !this.componentMap.get(uniqueKey).isEmpty();
        }
        return res;
    }

    @Override
    public <E extends R> boolean exists(Class<E> clazz, Object ... keyPart) {
        return this.exists(Key.create(clazz, keyPart));
    }

    @Override
    public <E extends R> E retrieve(UniqueKey<E> uniqueKey) {
        Optional first = this.retrieveMany(uniqueKey).stream().findFirst();
        return (E)((FacadeReady)first.orElseThrow(() -> new CoreRuntimeException("Impossible to load component " + uniqueKey.classField().getCanonicalName() + " with key parts " + uniqueKey.value().toString())));
    }

    @Override
    public <E extends R> E retrieve(Class<E> clazz, Object ... keyPart) {
        return this.retrieve(Key.create(clazz, keyPart));
    }

    @Override
    public <E extends R> List<E> retrieveMany(UniqueKey<E> uniqueKey) {
        List<E> readyObjectList = this.getReadyObjectList(uniqueKey);
        if (readyObjectList == null || readyObjectList.isEmpty()) {
            try {
                readyObjectList = this.buildComponentList(uniqueKey);
                for (FacadeReady readyObject : readyObjectList) {
                    this.register(readyObject.key(), (E)readyObject);
                    if (readyObject.key().registrationKey() != null) {
                        this.register(readyObject.key().registrationKey(), (E)readyObject);
                    }
                    readyObject.setup();
                }
            }
            catch (CoreException ce) {
                LOGGER.error(COMPONENT_RETRIEVAL_ERROR, ce);
                throw new CoreRuntimeException(ce);
            }
        }
        return readyObjectList;
    }

    @Override
    public <E extends R> List<E> retrieveMany(Class<E> clazz, Object ... keyPart) {
        return this.retrieveMany(Key.create(clazz, keyPart));
    }

    @Override
    public <E extends R> List<E> retrieveFilter(UniqueKey<E> uniqueKey) {
        return this.componentMap.entrySet().stream().filter(entry -> ((UniqueKey)entry.getKey()).classField() == uniqueKey.classField()).flatMap(s -> ((Set)s.getValue()).stream()).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends R> List<E> getReadyObjectList(UniqueKey<E> uniqueKey) {
        ArrayList<R> readyObjectList = null;
        Map<UniqueKey<? extends R>, Set<R>> map = this.componentMap;
        synchronized (map) {
            if (this.exists(uniqueKey)) {
                readyObjectList = new ArrayList<R>(this.componentMap.get(uniqueKey));
            }
        }
        return readyObjectList;
    }

    protected <E extends R> List<E> buildComponentList(UniqueKey<E> uniqueKey) throws CoreException {
        List<E> readyObjectList = this.globalFacade().componentFactory().buildComponents(uniqueKey.classField());
        for (FacadeReady readyObject : readyObjectList) {
            JRebirthEventType type = JRebirthEventType.NONE;
            if (readyObject instanceof Model) {
                type = JRebirthEventType.CREATE_MODEL;
            } else if (readyObject instanceof Service) {
                type = JRebirthEventType.CREATE_SERVICE;
            } else if (readyObject instanceof Command) {
                type = JRebirthEventType.CREATE_COMMAND;
            }
            this.globalFacade().trackEvent(type, this.getClass(), readyObject.getClass(), new String[0]);
            readyObject.localFacade(this);
            UniqueKey<?> readyKey = null;
            if (uniqueKey instanceof MultitonKey) {
                Object[] objectArray;
                Object keyPart = ((MultitonKey)uniqueKey).value();
                Class<?> clazz = readyObject.getClass();
                if (keyPart instanceof List) {
                    objectArray = ((List)keyPart).toArray();
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = keyPart;
                }
                readyKey = Key.createMulti(clazz, objectArray, uniqueKey.optionalData().toArray());
            } else if (uniqueKey instanceof ClassKey) {
                readyKey = Key.createSingle(readyObject.getClass(), uniqueKey.optionalData().toArray());
            }
            readyKey.registrationKey(uniqueKey);
            readyObject.key(readyKey);
        }
        return readyObjectList;
    }
}

