/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.facade;

import org.jrebirth.af.api.application.JRebirthApplication;
import org.jrebirth.af.api.component.factory.ComponentFactory;
import org.jrebirth.af.api.concurrent.IJRebirthThreadPoolExecutor;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.facade.GlobalFacade;
import org.jrebirth.af.api.facade.JRebirthEventType;
import org.jrebirth.af.api.link.Notifier;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.core.application.AbstractApplication;
import org.jrebirth.af.core.component.factory.DefaultComponentFactory;
import org.jrebirth.af.core.concurrent.JRebirthThreadPoolExecutor;
import org.jrebirth.af.core.facade.BehaviorFacade;
import org.jrebirth.af.core.facade.CommandFacade;
import org.jrebirth.af.core.facade.FacadeMessages;
import org.jrebirth.af.core.facade.JRebirthEventBase;
import org.jrebirth.af.core.facade.NamedThreadBuilder;
import org.jrebirth.af.core.facade.ServiceFacade;
import org.jrebirth.af.core.facade.UiFacade;
import org.jrebirth.af.core.link.NotifierBase;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.resource.provided.parameter.CoreParameters;
import org.jrebirth.af.core.resource.provided.parameter.ExtensionParameters;
import org.jrebirth.af.core.util.ParameterUtility;

public class GlobalFacadeBase
implements GlobalFacade,
FacadeMessages {
    public static final String JTP_BASE_NAME = "JTP Slot ";
    public static final String HPTP_BASE_NAME = "HPTP Slot ";
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(GlobalFacadeBase.class);
    private final ComponentFactory componentFactory = (ComponentFactory)ParameterUtility.buildCustomizableClass(ExtensionParameters.COMPONENT_FACTORY, DefaultComponentFactory.class, ComponentFactory.class);
    private final transient JRebirthApplication<?> application;
    private final transient Notifier notifier;
    private final transient UiFacade uiFacade;
    private final transient ServiceFacade serviceFacade;
    private final transient CommandFacade commandFacade;
    private final transient BehaviorFacade behaviorFacade;
    private final IJRebirthThreadPoolExecutor executorService;
    private final IJRebirthThreadPoolExecutor highPriorityExecutorService;
    private int eventSequence;

    public GlobalFacadeBase(JRebirthApplication<?> application) {
        this.application = application;
        this.trackEvent(JRebirthEventType.CREATE_APPLICATION, null, this.application().getClass(), new String[0]);
        LOGGER.trace(JTP_CREATION);
        int poolSize = Math.max(1, Math.round(CoreParameters.THREAD_POOL_SIZE_RATIO.get().floatValue() * (float)Runtime.getRuntime().availableProcessors()));
        this.executorService = new JRebirthThreadPoolExecutor(poolSize, new NamedThreadBuilder(((AbstractApplication)application).getPoolUncaughtExceptionHandler(), JTP_BASE_NAME));
        this.highPriorityExecutorService = new JRebirthThreadPoolExecutor(poolSize, new NamedThreadBuilder(((AbstractApplication)application).getPoolUncaughtExceptionHandler(), HPTP_BASE_NAME));
        this.trackEvent(JRebirthEventType.CREATE_GLOBAL_FACADE, this.application().getClass(), this.getClass(), new String[0]);
        this.notifier = this.buildNotifier();
        this.trackEvent(JRebirthEventType.CREATE_NOTIFIER, this.getClass(), this.notifier.getClass(), new String[0]);
        this.commandFacade = this.buildCommandFacade();
        this.trackEvent(JRebirthEventType.CREATE_COMMAND_FACADE, this.getClass(), this.commandFacade.getClass(), new String[0]);
        this.serviceFacade = this.buildServiceFacade();
        this.trackEvent(JRebirthEventType.CREATE_SERVICE_FACADE, this.getClass(), this.serviceFacade.getClass(), new String[0]);
        this.uiFacade = this.buildUiFacade();
        this.trackEvent(JRebirthEventType.CREATE_UI_FACADE, this.getClass(), this.uiFacade.getClass(), new String[0]);
        this.behaviorFacade = this.buildBehaviorFacade();
        this.trackEvent(JRebirthEventType.CREATE_BEHAVIOR_FACADE, this.getClass(), this.behaviorFacade.getClass(), new String[0]);
    }

    @Override
    public final void trackEvent(JRebirthEventType eventType, Class<?> source, Class<?> target, String ... eventData) {
        if (LOGGER.isInfoEnabled()) {
            JRebirthEventBase event = new JRebirthEventBase(this.eventSequence++, eventType, source == null ? null : source.getName(), target == null ? null : target.getName(), eventData);
            LOGGER.info(JREBIRTH_EVENT, event);
        }
    }

    @Override
    public ComponentFactory componentFactory() {
        return this.componentFactory;
    }

    @Override
    public final JRebirthApplication<?> application() {
        return this.application;
    }

    @Override
    public final Notifier notifier() {
        return this.notifier;
    }

    public final UiFacade uiFacade() {
        return this.uiFacade;
    }

    public final ServiceFacade serviceFacade() {
        return this.serviceFacade;
    }

    public final CommandFacade commandFacade() {
        return this.commandFacade;
    }

    public final BehaviorFacade behaviorFacade() {
        return this.behaviorFacade;
    }

    @Override
    public IJRebirthThreadPoolExecutor executorService() {
        return this.executorService;
    }

    @Override
    public IJRebirthThreadPoolExecutor highPriorityExecutorService() {
        return this.highPriorityExecutorService;
    }

    @Override
    public final void stop() throws CoreException {
        this.customStop();
        if (this.executorService() != null) {
            this.executorService().shutdown();
        }
        if (this.highPriorityExecutorService() != null) {
            this.highPriorityExecutorService().shutdown();
        }
    }

    protected void customStop() {
    }

    protected CommandFacade buildCommandFacade() {
        return new CommandFacade(this);
    }

    protected ServiceFacade buildServiceFacade() {
        return new ServiceFacade(this);
    }

    protected UiFacade buildUiFacade() {
        return new UiFacade(this);
    }

    protected BehaviorFacade buildBehaviorFacade() {
        return new BehaviorFacade(this);
    }

    protected NotifierBase buildNotifier() {
        return new NotifierBase(this);
    }
}

