/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.facade;

import java.util.StringTokenizer;
import org.jrebirth.af.api.facade.JRebirthEvent;
import org.jrebirth.af.api.facade.JRebirthEventType;

public final class JRebirthEventBase
implements JRebirthEvent {
    private int sequence;
    private JRebirthEventType eventType;
    private String source;
    private String target;
    private String eventData;

    public JRebirthEventBase(int sequence, JRebirthEventType eventType, String source, String target, String ... eventData) {
        this.sequence = sequence;
        this.eventType = eventType;
        this.source = source;
        this.target = target;
        if (eventData.length > 0) {
            this.eventData = eventData[0];
        }
    }

    public JRebirthEventBase(String eventSerialized) {
        this.parseString(eventSerialized);
    }

    @Override
    public int sequence() {
        return this.sequence;
    }

    @Override
    public JRebirthEvent sequence(int sequence) {
        this.sequence = sequence;
        return this;
    }

    @Override
    public JRebirthEventType eventType() {
        return this.eventType;
    }

    @Override
    public JRebirthEvent eventType(JRebirthEventType eventType) {
        this.eventType = eventType;
        return this;
    }

    @Override
    public String source() {
        return this.source;
    }

    @Override
    public JRebirthEvent source(String source) {
        this.source = source;
        return this;
    }

    @Override
    public String target() {
        return this.target;
    }

    @Override
    public JRebirthEvent target(String target) {
        this.target = target;
        return this;
    }

    @Override
    public String eventData() {
        return this.eventData;
    }

    @Override
    public JRebirthEvent eventData(String eventData) {
        this.eventData = eventData;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.sequence()).append("|").append((Object)this.eventType()).append("|").append(this.source()).append("|").append(this.target()).append("|").append(this.eventData()).append("|");
        return sb.toString();
    }

    private void parseString(String eventSerialized) {
        StringTokenizer st = new StringTokenizer(eventSerialized, "|");
        if (st.countTokens() >= 5) {
            this.sequence(Integer.parseInt(st.nextToken())).eventType(JRebirthEventType.valueOf(st.nextToken())).source(st.nextToken()).target(st.nextToken()).eventData(st.nextToken());
        }
    }
}

