/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.key;

import java.util.ArrayList;
import java.util.List;
import org.jrebirth.af.api.key.UniqueKey;

public class ClassKey<R>
implements UniqueKey<R> {
    private static final long serialVersionUID = -6535088425529890897L;
    private final Class<R> classField;
    private final List<Object> optionalDatas;
    private UniqueKey<? super R> registrationKey;

    public ClassKey(Class<R> classField, Object ... optionalData) {
        this.classField = classField;
        if (optionalData.length > 0) {
            this.optionalDatas = new ArrayList<Object>();
            for (Object data : optionalData) {
                this.optionalDatas.add(data);
            }
        } else {
            this.optionalDatas = null;
        }
    }

    @Override
    public String key() {
        return this.classField().getName();
    }

    @Override
    public Object value() {
        return this.classField();
    }

    public String toString() {
        return this.classField().toString();
    }

    public int hashCode() {
        return this.classField().hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && this.classField().equals(((ClassKey)obj).classField());
    }

    @Override
    public Class<R> classField() {
        return this.classField;
    }

    @Override
    public List<Object> optionalData() {
        return this.optionalDatas == null ? new ArrayList() : this.optionalDatas;
    }

    @Override
    public void registrationKey(UniqueKey<? super R> uniqueKey) {
        this.registrationKey = uniqueKey;
    }

    @Override
    public UniqueKey<? super R> registrationKey() {
        return this.registrationKey;
    }
}

