/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.link;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import org.jrebirth.af.api.annotation.AfterInit;
import org.jrebirth.af.api.annotation.BeforeInit;
import org.jrebirth.af.api.annotation.Link;
import org.jrebirth.af.api.annotation.OnRelease;
import org.jrebirth.af.api.annotation.SkipAnnotation;
import org.jrebirth.af.api.command.Command;
import org.jrebirth.af.api.component.basic.Component;
import org.jrebirth.af.api.component.basic.InnerComponent;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.exception.CoreRuntimeException;
import org.jrebirth.af.api.facade.FacadeReady;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.api.service.Service;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.api.wave.annotation.OnWave;
import org.jrebirth.af.api.wave.contract.WaveType;
import org.jrebirth.af.core.component.basic.CBuilder;
import org.jrebirth.af.core.link.LinkMessages;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.util.ClassUtility;
import org.jrebirth.af.core.util.MultiMap;
import org.jrebirth.af.core.wave.WaveTypeRegistry;

public final class ComponentEnhancer
implements LinkMessages {
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(ComponentEnhancer.class);

    private ComponentEnhancer() {
    }

    public static boolean canProcessAnnotation(Class<? extends Component<?>> componentClass) {
        SkipAnnotation skip = ClassUtility.getLastClassAnnotation(componentClass, SkipAnnotation.class);
        return skip != null && !skip.value();
    }

    public static void injectComponent(Component<?> component) {
        ComponentEnhancer.injectComponent(component, false);
    }

    public static void injectInnerComponent(Component<?> component) {
        ComponentEnhancer.injectComponent(component, true);
    }

    private static void injectComponent(Component<?> component, boolean inner) {
        for (Field field : ClassUtility.getAnnotatedFields(component.getClass(), Link.class)) {
            String keyPart = field.getAnnotation(Link.class).value();
            if (inner) {
                if (!InnerComponent.class.isAssignableFrom(field.getType())) continue;
                if (keyPart.isEmpty()) {
                    ComponentEnhancer.injectInnerComponent(component, field, new Object[0]);
                    continue;
                }
                ComponentEnhancer.injectInnerComponent(component, field, keyPart);
                continue;
            }
            if (!Component.class.isAssignableFrom(field.getType())) continue;
            if (keyPart.isEmpty()) {
                ComponentEnhancer.injectComponent(component, field, new Object[0]);
                continue;
            }
            ComponentEnhancer.injectComponent(component, field, keyPart);
        }
    }

    private static void injectComponent(FacadeReady<?> component, Field field, Object ... keyParts) {
        try {
            if (Command.class.isAssignableFrom(field.getType())) {
                ClassUtility.setFieldValue(field, component, component.localFacade().globalFacade().commandFacade().retrieve(field.getType(), keyParts));
            } else if (Service.class.isAssignableFrom(field.getType())) {
                ClassUtility.setFieldValue(field, component, component.localFacade().globalFacade().serviceFacade().retrieve(field.getType(), keyParts));
            } else if (Model.class.isAssignableFrom(field.getType())) {
                ClassUtility.setFieldValue(field, component, component.localFacade().globalFacade().uiFacade().retrieve(field.getType(), keyParts));
            }
        }
        catch (IllegalArgumentException | CoreException e) {
            LOGGER.error(COMPONENT_INJECTION_FAILURE, component.getClass(), e);
        }
    }

    private static void injectInnerComponent(Component<?> component, Field field, Object ... keyParts) {
        ParameterizedType innerComponentType = (ParameterizedType)field.getGenericType();
        Class componentType = (Class)innerComponentType.getActualTypeArguments()[0];
        try {
            ClassUtility.setFieldValue(field, component, CBuilder.innerComponent(componentType, keyParts).host(component));
        }
        catch (IllegalArgumentException | CoreException e) {
            LOGGER.error(COMPONENT_INJECTION_FAILURE, component.getClass(), e);
        }
    }

    public static MultiMap<String, Method> defineLifecycleMethod(Component<?> component) {
        MultiMap<String, Method> lifecycleMethod = new MultiMap<String, Method>();
        ComponentEnhancer.manageLifecycleAnnotation(component, lifecycleMethod, BeforeInit.class);
        ComponentEnhancer.manageLifecycleAnnotation(component, lifecycleMethod, AfterInit.class);
        ComponentEnhancer.manageLifecycleAnnotation(component, lifecycleMethod, OnRelease.class);
        return lifecycleMethod;
    }

    private static void manageLifecycleAnnotation(Component<?> component, MultiMap<String, Method> lifecycleMethod, Class<? extends Annotation> annotationClass) {
        for (Method method : ClassUtility.getAnnotatedMethods(component.getClass(), annotationClass)) {
            lifecycleMethod.add(annotationClass.getName(), method);
        }
    }

    public static void manageOnWaveAnnotation(Component<?> component) {
        for (OnWave clsOnWave : (OnWave[])component.getClass().getAnnotationsByType(OnWave.class)) {
            ComponentEnhancer.manageUniqueWaveTypeAction(component, clsOnWave.value(), null);
        }
        for (Method method : ClassUtility.getAnnotatedMethods(component.getClass(), OnWave.class)) {
            for (OnWave clsOnWave : (OnWave[])method.getAnnotationsByType(OnWave.class)) {
                ComponentEnhancer.manageUniqueWaveTypeAction(component, clsOnWave.value(), method);
            }
        }
    }

    private static void manageUniqueWaveTypeAction(Component<?> component, String waveActionName, Method method) {
        WaveType wt = WaveTypeRegistry.getWaveType(waveActionName);
        if (wt == null) {
            throw new CoreRuntimeException("WaveType '" + waveActionName + "' not found into WaveTypeRegistry.");
        }
        if (method == null || "processWave".equals(method.getName())) {
            component.listen(wt);
        } else {
            component.listen(null, method, wt);
        }
    }
}

