/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.link;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jrebirth.af.api.annotation.PriorityLevel;
import org.jrebirth.af.api.component.basic.Component;
import org.jrebirth.af.api.concurrent.RunInto;
import org.jrebirth.af.api.concurrent.RunType;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.WaveException;
import org.jrebirth.af.api.wave.WaveHandler;
import org.jrebirth.af.api.wave.checker.WaveChecker;
import org.jrebirth.af.api.wave.contract.WaveData;
import org.jrebirth.af.core.concurrent.JRebirth;
import org.jrebirth.af.core.link.LinkMessages;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.util.CheckerUtility;
import org.jrebirth.af.core.util.ClassUtility;

public class WaveHandlerBase
implements WaveHandler,
LinkMessages {
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(WaveHandlerBase.class);
    private final Component<?> waveReady;
    private final Method defaultMethod;
    private final WaveChecker waveChecker;

    public WaveHandlerBase(Component<?> waveReady, WaveChecker waveChecker, Method defaultMethod) {
        this.waveReady = waveReady;
        this.waveChecker = waveChecker;
        this.defaultMethod = defaultMethod;
    }

    @Override
    public boolean check(Wave wave) {
        return this.waveChecker == null || (Boolean)this.waveChecker.call(wave) != false;
    }

    @Override
    public Component<?> getWaveReady() {
        return this.waveReady;
    }

    @Override
    public void handle(Wave wave) throws WaveException {
        RunInto runInto;
        Method customMethod = this.retrieveCustomMethod(wave);
        if (customMethod == null) {
            try {
                customMethod = this.getWaveReady().getClass().getDeclaredMethod("processWave", Wave.class);
            }
            catch (IllegalArgumentException | NoSuchMethodException e) {
                LOGGER.error(WAVE_DISPATCH_ERROR, e);
                throw new WaveException(wave, (Throwable)e);
            }
        }
        PriorityLevel priority = (runInto = customMethod.getAnnotation(RunInto.class)) == null ? PriorityLevel.Normal : runInto.priority();
        RunType runType = runInto == null ? null : runInto.value();
        WaveHandlerBase waveHandler = this;
        Method method = customMethod;
        String runnableName = this.getWaveReady().getClass().getSimpleName() + " handle wave " + wave.toString();
        Runnable waveHandlerRunnable = () -> {
            try {
                this.performHandle(wave, method);
            }
            catch (WaveException e) {
                LOGGER.error(WAVE_HANDLING_ERROR, e);
            }
            finally {
                wave.removeWaveHandler(waveHandler);
            }
        };
        if (runType != null && runType == RunType.JAT || runType == null && this.getWaveReady() instanceof Model) {
            JRebirth.runIntoJAT(runnableName, waveHandlerRunnable);
        } else if (runType != null && runType == RunType.JTP) {
            JRebirth.runIntoJTP(runnableName, priority, waveHandlerRunnable);
        } else {
            waveHandlerRunnable.run();
        }
    }

    private Method retrieveCustomMethod(Wave wave) {
        Method customMethod = null;
        Method method = customMethod = this.defaultMethod == null ? (Method)ClassUtility.retrieveMethodList(this.getWaveReady().getClass(), wave.waveType().toString()).stream().filter(m -> CheckerUtility.checkMethodSignature(m, wave.waveType().items())).findFirst().orElse(null) : this.defaultMethod;
        if (customMethod == null) {
            LOGGER.info(CUSTOM_METHOD_NOT_FOUND);
        }
        return customMethod;
    }

    private void performHandle(Wave wave, Method method) throws WaveException {
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        if (!"processWave".equals(method.getName())) {
            for (WaveData<?> wd : wave.waveDatas()) {
                if (!wd.key().isParameter()) continue;
                parameterValues.add(wd.value());
            }
        }
        parameterValues.add(wave);
        try {
            ClassUtility.callMethod(method, this.getWaveReady(), parameterValues.toArray());
        }
        catch (CoreException e) {
            LOGGER.error(WAVE_DISPATCH_ERROR, e);
            throw new WaveException(wave, (Throwable)e);
        }
    }
}

