/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.log;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.core.log.AbstractLogAdapter;
import org.jrebirth.af.core.log.LogbackAdapter;
import org.jrebirth.af.core.log.Slf4jAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JRLoggerFactory {
    private static ConcurrentMap<String, JRLogger> loggerMap = new ConcurrentHashMap<String, JRLogger>();

    private JRLoggerFactory() {
    }

    public static JRLogger getLogger(Class<?> clazz) {
        JRLogger logger = (JRLogger)loggerMap.get(clazz.getName());
        if (logger == null) {
            AbstractLogAdapter newInstance = null;
            Logger innerLogger = LoggerFactory.getLogger(clazz);
            newInstance = "ch.qos.logback.classic.Logger".equals(innerLogger.getClass().getName()) ? new LogbackAdapter((ch.qos.logback.classic.Logger)innerLogger) : new Slf4jAdapter(innerLogger);
            JRLogger oldInstance = loggerMap.putIfAbsent(clazz.getName(), newInstance);
            logger = oldInstance == null ? newInstance : oldInstance;
        }
        return logger;
    }
}

