/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.log;

import org.jrebirth.af.api.resource.i18n.MessageItem;
import org.jrebirth.af.core.log.AbstractLogAdapter;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class Slf4jAdapter
extends AbstractLogAdapter {
    public Slf4jAdapter(Logger logger) {
        super(logger);
    }

    @Override
    public void log(MessageItem messageItem) {
        this.log(messageItem, null, new Object[0]);
    }

    @Override
    public void log(MessageItem messageItem, Throwable t) {
        this.log(messageItem, t, new Object[0]);
    }

    @Override
    public void log(MessageItem messageItem, Object ... parameters) {
        this.log(messageItem, null, parameters);
    }

    @Override
    public void log(MessageItem messageItem, Throwable t, Object ... parameters) {
        switch (messageItem.getLevel()) {
            case Trace: {
                this.trace(messageItem, t, parameters);
                break;
            }
            case Debug: {
                this.debug(messageItem, t, parameters);
                break;
            }
            case Warn: {
                this.warn(messageItem, t, parameters);
                break;
            }
            case Error: 
            case Exception: {
                this.error(messageItem, t, parameters);
                break;
            }
            case Info: {
                this.info(messageItem, t, parameters);
                break;
            }
        }
    }

    @Override
    public void trace(MessageItem messageItem) {
        this.getLogger().trace(messageItem.getMarker(), messageItem.getText(new Object[0]));
    }

    @Override
    public void trace(MessageItem messageItem, Throwable t) {
        this.getLogger().trace(messageItem.getMarker(), messageItem.getText(new Object[0]), t);
    }

    @Override
    public void trace(MessageItem messageItem, Object ... parameters) {
        if (this.getLogger().isTraceEnabled(messageItem.getMarker())) {
            this.getLogger().trace(messageItem.getMarker(), messageItem.getText(parameters));
        }
    }

    @Override
    public void trace(MessageItem messageItem, Throwable t, Object ... parameters) {
        if (this.getLogger().isTraceEnabled(messageItem.getMarker())) {
            this.getLogger().trace(messageItem.getMarker(), messageItem.getText(parameters), t);
        }
    }

    @Override
    public void debug(MessageItem messageItem) {
        this.getLogger().debug(messageItem.getMarker(), messageItem.getText(new Object[0]));
    }

    @Override
    public void debug(MessageItem messageItem, Throwable t) {
        this.getLogger().debug(messageItem.getMarker(), messageItem.getText(new Object[0]), t);
    }

    @Override
    public void debug(MessageItem messageItem, Object ... parameters) {
        if (this.getLogger().isDebugEnabled(messageItem.getMarker())) {
            this.getLogger().debug(messageItem.getMarker(), messageItem.getText(parameters));
        }
    }

    @Override
    public void debug(MessageItem messageItem, Throwable t, Object ... parameters) {
        if (this.getLogger().isDebugEnabled(messageItem.getMarker())) {
            this.getLogger().debug(messageItem.getMarker(), messageItem.getText(parameters), t);
        }
    }

    @Override
    public void info(MessageItem messageItem) {
        this.getLogger().info(messageItem.getMarker(), messageItem.getText(new Object[0]));
    }

    @Override
    public void info(MessageItem messageItem, Throwable t) {
        this.getLogger().info(messageItem.getMarker(), messageItem.getText(new Object[0]), t);
    }

    @Override
    public void info(MessageItem messageItem, Object ... parameters) {
        if (this.getLogger().isInfoEnabled(messageItem.getMarker())) {
            this.getLogger().info(messageItem.getMarker(), messageItem.getText(parameters));
        }
    }

    @Override
    public void info(MessageItem messageItem, Throwable t, Object ... parameters) {
        if (this.getLogger().isInfoEnabled(messageItem.getMarker())) {
            this.getLogger().info(messageItem.getMarker(), messageItem.getText(parameters), t);
        }
    }

    @Override
    public void warn(MessageItem messageItem) {
        this.getLogger().warn(messageItem.getMarker(), messageItem.getText(new Object[0]));
    }

    @Override
    public void warn(MessageItem messageItem, Throwable t) {
        this.getLogger().warn(messageItem.getMarker(), messageItem.getText(new Object[0]), t);
    }

    @Override
    public void warn(MessageItem messageItem, Object ... parameters) {
        if (this.getLogger().isWarnEnabled(messageItem.getMarker())) {
            this.getLogger().warn(messageItem.getMarker(), messageItem.getText(parameters));
        }
    }

    @Override
    public void warn(MessageItem messageItem, Throwable t, Object ... parameters) {
        if (this.getLogger().isWarnEnabled(messageItem.getMarker())) {
            this.getLogger().warn(messageItem.getMarker(), messageItem.getText(parameters), t);
        }
    }

    @Override
    public void error(MessageItem messageItem) {
        this.getLogger().error(messageItem.getMarker(), messageItem.getText(new Object[0]));
        this.throwError(messageItem, null, new Object[0]);
    }

    @Override
    public void error(MessageItem messageItem, Throwable t) {
        this.getLogger().error(messageItem.getMarker(), messageItem.getText(new Object[0]), t);
        this.throwError(messageItem, t, new Object[0]);
    }

    @Override
    public void error(MessageItem messageItem, Object ... parameters) {
        if (this.getLogger().isErrorEnabled(messageItem.getMarker())) {
            this.getLogger().error(messageItem.getMarker(), messageItem.getText(parameters));
        }
        this.throwError(messageItem, null, parameters);
    }

    @Override
    public void error(MessageItem messageItem, Throwable t, Object ... parameters) {
        if (this.getLogger().isErrorEnabled(messageItem.getMarker())) {
            this.getLogger().error(messageItem.getMarker(), messageItem.getText(parameters), t);
        }
        this.throwError(messageItem, t, parameters);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return this.getLogger().isDebugEnabled(marker);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.getLogger().isErrorEnabled();
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return this.getLogger().isErrorEnabled(marker);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.getLogger().isInfoEnabled();
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return this.getLogger().isInfoEnabled(marker);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.getLogger().isTraceEnabled();
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return this.getLogger().isTraceEnabled(marker);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.getLogger().isWarnEnabled();
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return this.getLogger().isWarnEnabled(marker);
    }
}

