/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.module;

import org.jrebirth.af.api.annotation.PriorityLevel;
import org.jrebirth.af.api.command.Command;
import org.jrebirth.af.api.component.basic.Component;
import org.jrebirth.af.api.exception.CoreRuntimeException;
import org.jrebirth.af.api.facade.GlobalFacade;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.api.module.ModuleStarter;
import org.jrebirth.af.api.service.Service;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.core.component.factory.RegistrationItemBase;
import org.jrebirth.af.core.component.factory.RegistrationPointItemBase;
import org.jrebirth.af.core.concurrent.JRebirthThread;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.module.ModuleMessages;

public abstract class AbstractModuleStarter
implements ModuleStarter,
ModuleMessages {
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(AbstractModuleStarter.class);

    protected void define(Class<? extends Component<?>> interfaceClass, boolean exclusive, boolean reverse) {
        this.preloadClass(interfaceClass);
        this.getFacade().componentFactory().define(((RegistrationPointItemBase)RegistrationPointItemBase.create().interfaceClass((Class)interfaceClass)).exclusive(exclusive).reverse(reverse));
    }

    protected void register(Class<? extends Component<?>> interfaceClass, Class<? extends Component<?>> implClass) {
        this.register(interfaceClass, implClass, PriorityLevel.Normal, 0);
    }

    protected void register(Class<? extends Component<?>> interfaceClass, Class<? extends Component<?>> implClass, PriorityLevel priority) {
        this.register(interfaceClass, implClass, priority, 0);
    }

    protected void register(Class<? extends Component<?>> interfaceClass, Class<? extends Component<?>> implClass, PriorityLevel priority, int weight) {
        this.preloadClass(interfaceClass);
        this.getFacade().componentFactory().register(((RegistrationItemBase)((RegistrationItemBase)RegistrationItemBase.create().interfaceClass((Class)interfaceClass)).implClass((Class)implClass)).priority(priority).weight(weight));
    }

    protected void bootComponent(Class<? extends Component<?>> componentClass) {
        this.preloadClass(componentClass);
        try {
            if (Command.class.isAssignableFrom(componentClass)) {
                this.getFacade().commandFacade().retrieve(componentClass, new Object[0]);
            } else if (Service.class.isAssignableFrom(componentClass)) {
                this.getFacade().serviceFacade().retrieve(componentClass, new Object[0]);
            } else if (Model.class.isAssignableFrom(componentClass)) {
                this.getFacade().uiFacade().retrieve(componentClass, new Object[0]);
            }
        }
        catch (CoreRuntimeException e) {
            LOGGER.error(BOOT_COMPONENT_ERROR, e, componentClass.getName());
        }
    }

    protected void preloadClass(Class<?> objectClass) {
        try {
            Class.forName(objectClass.getName());
        }
        catch (ClassNotFoundException e) {
            LOGGER.error(CLASS_NOT_FOUND, e, objectClass.getName());
        }
    }

    protected GlobalFacade getFacade() {
        return JRebirthThread.getThread().getFacade();
    }
}

