/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.resource;

import java.util.concurrent.atomic.AtomicInteger;
import org.jrebirth.af.api.resource.ResourceParams;
import org.jrebirth.af.api.resource.color.ColorItem;
import org.jrebirth.af.api.resource.color.ColorParams;
import org.jrebirth.af.api.resource.font.FontItem;
import org.jrebirth.af.api.resource.font.FontParams;
import org.jrebirth.af.api.resource.fxml.FXMLItem;
import org.jrebirth.af.api.resource.fxml.FXMLParams;
import org.jrebirth.af.api.resource.i18n.MessageItem;
import org.jrebirth.af.api.resource.image.ImageItem;
import org.jrebirth.af.api.resource.image.ImageParams;
import org.jrebirth.af.api.resource.parameter.ParameterItem;
import org.jrebirth.af.api.resource.style.StyleSheetItem;
import org.jrebirth.af.api.resource.style.StyleSheetParams;
import org.jrebirth.af.core.resource.color.ColorItemImpl;
import org.jrebirth.af.core.resource.font.FontItemImpl;
import org.jrebirth.af.core.resource.fxml.FXMLItemImpl;
import org.jrebirth.af.core.resource.i18n.Message;
import org.jrebirth.af.core.resource.i18n.MessageItemImpl;
import org.jrebirth.af.core.resource.image.ImageItemImpl;
import org.jrebirth.af.core.resource.parameter.ObjectParameter;
import org.jrebirth.af.core.resource.parameter.ParameterItemImpl;
import org.jrebirth.af.core.resource.style.StyleSheetItemImpl;

public final class Resources {
    public static final String PATH_SEP = "/";
    private static AtomicInteger parameterIdGenerator = new AtomicInteger();
    private static AtomicInteger colorIdGenerator = new AtomicInteger();
    private static AtomicInteger fontIdGenerator = new AtomicInteger();
    private static AtomicInteger imageIdGenerator = new AtomicInteger();
    private static AtomicInteger styleSheetIdGenerator = new AtomicInteger();
    private static AtomicInteger fxmlIdGenerator = new AtomicInteger();
    private static AtomicInteger messageIdGenerator = new AtomicInteger();

    private Resources() {
    }

    public static <O> ParameterItem<O> create(ObjectParameter<O> parameterParams) {
        return ((ParameterItem)ParameterItemImpl.create(parameterParams.object()).uid(parameterIdGenerator.incrementAndGet())).set(parameterParams);
    }

    public static <O> ParameterItem<O> create(String name, O defaultValue) {
        return Resources.create(new ObjectParameter<O>(name, defaultValue));
    }

    public static ColorItem create(ColorParams colorParams) {
        return ((ColorItem)ColorItemImpl.create().uid(colorIdGenerator.incrementAndGet())).set(colorParams);
    }

    public static FontItem create(FontParams fontParams) {
        return ((FontItem)FontItemImpl.create().uid(fontIdGenerator.incrementAndGet())).set(fontParams);
    }

    public static ImageItem create(ImageParams imageParams) {
        return ((ImageItem)ImageItemImpl.create().uid(imageIdGenerator.incrementAndGet())).set(imageParams);
    }

    public static StyleSheetItem create(StyleSheetParams styleSheetParams) {
        return ((StyleSheetItem)StyleSheetItemImpl.create().uid(styleSheetIdGenerator.incrementAndGet())).set(styleSheetParams);
    }

    public static FXMLItem create(FXMLParams fxmlParams) {
        return ((FXMLItem)FXMLItemImpl.create(true).uid(fxmlIdGenerator.incrementAndGet())).set(fxmlParams);
    }

    public static FXMLItem create(FXMLParams fxmlParams, boolean isSingleton) {
        return ((FXMLItem)FXMLItemImpl.create(isSingleton).uid(fxmlIdGenerator.incrementAndGet())).set(fxmlParams);
    }

    public static MessageItem create(Message messageParams) {
        return (MessageItem)((MessageItem)MessageItemImpl.create().uid(messageIdGenerator.incrementAndGet())).set(messageParams);
    }

    public static boolean isNotAutoRefreshParam(ResourceParams params) {
        return !(params instanceof ObjectParameter) || !"autoRefreshResource".equals(((ObjectParameter)params).name());
    }
}

