/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.resource.builder;

import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.jrebirth.af.api.resource.ResourceItem;
import org.jrebirth.af.api.resource.ResourceParams;
import org.jrebirth.af.api.resource.builder.ResourceBuilder;
import org.jrebirth.af.core.resource.Resources;
import org.jrebirth.af.core.resource.provided.parameter.CoreParameters;

public abstract class AbstractResourceBuilder<I extends ResourceItem<?, ?, ?>, P extends ResourceParams, R>
implements ResourceBuilder<I, P, R> {
    private final Map<I, P> paramsMap = new WeakHashMap<I, P>();
    protected final Map<String, SoftReference<R>> resourceMap = new WeakHashMap<String, SoftReference<R>>();

    @Override
    public void storeParams(I key, P params) {
        this.paramsMap.put(key, params);
        if (Resources.isNotAutoRefreshParam(params) && CoreParameters.AUTO_REFRESH_RESOURCE.get().booleanValue()) {
            params.activateAutoRefresh();
        }
    }

    @Override
    public P getParam(I key) {
        return (P)((ResourceParams)this.paramsMap.get(key));
    }

    @Override
    public String getParamKey(I key) {
        return this.getParam(key).getKey();
    }

    @Override
    public R get(I key) {
        R resource;
        P params = this.getParam(key);
        String paramsKey = params.getKey();
        SoftReference<R> resourceSoftRef = this.resourceMap.get(paramsKey);
        R r = resource = resourceSoftRef == null ? null : (R)resourceSoftRef.get();
        if (resourceSoftRef == null || resource == null) {
            resource = this.buildResource(key, params);
            this.set(paramsKey, resource);
            params.hasChanged(false);
        }
        return resource;
    }

    @Override
    public void set(String key, R resource) {
        this.resourceMap.put(key, new SoftReference<R>(resource));
    }

    protected abstract R buildResource(I var1, P var2);
}

