/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.resource.color;

import javafx.scene.paint.Color;
import org.jrebirth.af.api.resource.builder.ResourceBuilder;
import org.jrebirth.af.api.resource.color.ColorItem;
import org.jrebirth.af.api.resource.color.ColorParams;
import org.jrebirth.af.core.resource.builder.AbstractResourceBuilder;
import org.jrebirth.af.core.resource.color.GrayColor;
import org.jrebirth.af.core.resource.color.HSBColor;
import org.jrebirth.af.core.resource.color.RGB01Color;
import org.jrebirth.af.core.resource.color.RGB255Color;
import org.jrebirth.af.core.resource.color.WebColor;

public final class ColorBuilder
extends AbstractResourceBuilder<ColorItem, ColorParams, Color>
implements ResourceBuilder<ColorItem, ColorParams, Color> {
    private static final String HEXA_PREFIX = "#";

    @Override
    protected Color buildResource(ColorItem ci, ColorParams cp) {
        Color color = null;
        if (cp instanceof WebColor) {
            color = this.buildWebColor((WebColor)cp);
        } else if (cp instanceof RGB01Color) {
            color = this.buildRGB01Color((RGB01Color)cp);
        } else if (cp instanceof RGB255Color) {
            color = this.buildRGB255Color((RGB255Color)cp);
        } else if (cp instanceof HSBColor) {
            color = this.buildHSBColor((HSBColor)cp);
        } else if (cp instanceof GrayColor) {
            color = this.buildGrayColor((GrayColor)cp);
        }
        return color;
    }

    private Color buildWebColor(WebColor wColor) {
        Color color = null;
        color = wColor.opacity() >= 1.0 ? Color.web((String)(HEXA_PREFIX + wColor.hex())) : Color.web((String)(HEXA_PREFIX + wColor.hex()), (double)wColor.opacity());
        return color;
    }

    private Color buildRGB01Color(RGB01Color rColor) {
        Color color = null;
        color = rColor.opacity() >= 1.0 ? Color.color((double)rColor.red(), (double)rColor.green(), (double)rColor.blue()) : Color.color((double)rColor.red(), (double)rColor.green(), (double)rColor.blue(), (double)rColor.opacity());
        return color;
    }

    private Color buildRGB255Color(RGB255Color rColor) {
        Color color = null;
        color = rColor.opacity() >= 1.0 ? Color.rgb((int)rColor.red(), (int)rColor.green(), (int)rColor.blue()) : Color.rgb((int)rColor.red(), (int)rColor.green(), (int)rColor.blue(), (double)rColor.opacity());
        return color;
    }

    private Color buildHSBColor(HSBColor hsbColor) {
        Color color = null;
        color = hsbColor.opacity() >= 1.0 ? Color.hsb((double)hsbColor.hue(), (double)hsbColor.saturation(), (double)hsbColor.brightness()) : Color.hsb((double)hsbColor.hue(), (double)hsbColor.saturation(), (double)hsbColor.brightness(), (double)hsbColor.opacity());
        return color;
    }

    private Color buildGrayColor(GrayColor gColor) {
        Color color = null;
        color = gColor.opacity() >= 1.0 ? Color.gray((double)gColor.gray()) : Color.gray((double)gColor.gray(), (double)gColor.opacity());
        return color;
    }
}

