/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.resource.color;

import java.util.Arrays;
import java.util.List;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.jrebirth.af.core.resource.color.AbstractBaseColor;

public class WebColor
extends AbstractBaseColor {
    private final StringProperty hexProperty = new SimpleStringProperty();

    public WebColor(String hex) {
        this.hexProperty.set((Object)hex);
    }

    public WebColor(String hex, double opacity) {
        super(opacity);
        this.hexProperty.set((Object)hex);
    }

    public String hex() {
        return (String)this.hexProperty.get();
    }

    public StringProperty hexProperty() {
        return this.hexProperty;
    }

    @Override
    public void parse(String ... parameters) {
        if (parameters.length >= 1) {
            String hexValue = parameters[0];
            if (hexValue.startsWith("0x")) {
                hexValue = hexValue.substring(2);
            }
            if (hexValue.charAt(0) == '#') {
                hexValue = hexValue.substring(1);
            }
            switch (hexValue.length()) {
                case 3: {
                    this.hexProperty.set((Object)hexValue);
                    break;
                }
                case 8: {
                    break;
                }
                default: {
                    this.hexProperty.set((Object)hexValue);
                }
            }
        }
        if (parameters.length == 2) {
            this.opacityProperty().set(Double.parseDouble(parameters[1]));
        }
    }

    @Override
    protected List<? extends Object> getFieldValues() {
        return Arrays.asList(this.hex(), this.opacity());
    }
}

