/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.resource.font;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import org.jrebirth.af.api.resource.builder.VariantResourceBuilder;
import org.jrebirth.af.api.resource.font.FontItem;
import org.jrebirth.af.api.resource.font.FontParams;
import org.jrebirth.af.core.resource.builder.AbstractVariantResourceBuilder;
import org.jrebirth.af.core.resource.font.AbstractBaseFont;
import org.jrebirth.af.core.resource.font.FamilyFont;
import org.jrebirth.af.core.resource.font.RealFont;
import org.jrebirth.af.core.resource.provided.parameter.ResourceParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FontBuilder
extends AbstractVariantResourceBuilder<FontItem, FontParams, Font, Double>
implements VariantResourceBuilder<FontItem, FontParams, Font, Double> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FontBuilder.class);

    @Override
    protected Font buildResource(FontItem fontItem, FontParams jrFont, Double variant) {
        try {
            AbstractBaseFont vParams = (AbstractBaseFont)jrFont.clone();
            vParams.sizeProperty().set(variant.doubleValue());
            vParams.hasChanged(true);
            return this.buildResource(fontItem, vParams);
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    protected Font buildResource(FontItem fontItem, FontParams jrFont) {
        Font font = null;
        font = jrFont instanceof RealFont ? this.buildRealFont((RealFont)jrFont) : (jrFont instanceof FamilyFont ? this.buildFamilyFont((FamilyFont)jrFont) : Font.getDefault());
        return font;
    }

    private Font buildRealFont(RealFont rFont) {
        this.checkFontStatus(rFont);
        return Font.font((String)this.transformFontName(rFont.name().name()), (double)rFont.size());
    }

    private Font buildFamilyFont(FamilyFont familyFont) {
        Font font = null;
        font = familyFont.posture() == null && familyFont.weight() == null ? Font.font((String)this.transformFontName(familyFont.family()), (double)familyFont.size()) : (familyFont.posture() == null ? Font.font((String)this.transformFontName(familyFont.family()), (FontWeight)familyFont.weight(), (double)familyFont.size()) : (familyFont.weight() == null ? Font.font((String)this.transformFontName(familyFont.family()), (FontPosture)familyFont.posture(), (double)familyFont.size()) : Font.font((String)this.transformFontName(familyFont.family()), (FontWeight)familyFont.weight(), (FontPosture)familyFont.posture(), (double)familyFont.size())));
        return font;
    }

    private String transformFontName(String fontName) {
        return fontName.replace("_", " ");
    }

    private void checkFontStatus(FontParams fontParams) {
        List fonts = Font.getFontNames((String)this.transformFontName(fontParams.name().name()));
        Font font = null;
        String fontName = null;
        if (fonts.isEmpty()) {
            List<String> fontPaths = fontParams instanceof RealFont && ((RealFont)fontParams).skipFontsFolder() ? Collections.singletonList("") : ResourceParameters.FONT_FOLDER.get();
            for (int i = 0; i < fontPaths.size() && font == null; ++i) {
                String fontPath = fontPaths.get(i);
                if (!fontPath.isEmpty()) {
                    fontPath = fontPath + "/";
                }
                fontName = fontPath + this.transformFontName(fontParams.name().name()) + "." + (Object)((Object)fontParams.extension());
                LOGGER.trace("Try to load Transformed Font  {}", (Object)fontName);
                font = Font.loadFont((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream(fontName), (double)fontParams.size());
                if (font == null) {
                    fontName = fontPath + fontParams.name().name() + "." + (Object)((Object)fontParams.extension());
                    LOGGER.trace("Try to load Raw Font  {}", (Object)fontName);
                    font = Font.loadFont((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream(fontName), (double)fontParams.size());
                    if (font == null) continue;
                    LOGGER.info("{} Raw Font loaded", (Object)fontName);
                    continue;
                }
                LOGGER.info("{} Transformed Font loaded", (Object)fontName);
            }
            if (font == null) {
                LOGGER.error("Font : {} not found into base folder: {}", (Object)(fontParams.name().name() + "." + (Object)((Object)fontParams.extension())), (Object)ResourceParameters.FONT_FOLDER.get());
            }
        }
    }
}

